/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.extension;

import com.atlassian.plugin.spring.scanner.util.AnnotationIndexReader;
import com.atlassian.plugin.spring.scanner.util.BeanDefinitionChecker;
import java.beans.Introspector;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.util.ClassUtils;

public class ClassIndexBeanDefinitionScanner {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final BeanDefinitionRegistry registry;
    private final String profileName;
    private final BundleContext bundleContext;

    public ClassIndexBeanDefinitionScanner(BeanDefinitionRegistry registry, String profileName, BundleContext bundleContext) {
        this.registry = registry;
        this.profileName = profileName;
        this.bundleContext = bundleContext;
    }

    protected Set<BeanDefinitionHolder> doScan() {
        LinkedHashSet<BeanDefinitionHolder> beanDefinitions = new LinkedHashSet<BeanDefinitionHolder>();
        Map<String, BeanDefinition> namesAndDefinitions = this.findCandidateComponents();
        for (Map.Entry<String, BeanDefinition> nameAndDefinition : namesAndDefinitions.entrySet()) {
            if (!BeanDefinitionChecker.needToRegister(nameAndDefinition.getKey(), nameAndDefinition.getValue(), this.registry)) continue;
            BeanDefinitionHolder definitionHolder = new BeanDefinitionHolder(nameAndDefinition.getValue(), nameAndDefinition.getKey());
            beanDefinitions.add(definitionHolder);
            this.registerBeanDefinition(definitionHolder, this.registry);
        }
        return beanDefinitions;
    }

    public Map<String, BeanDefinition> findCandidateComponents() {
        HashMap<String, BeanDefinition> candidates = new HashMap<String, BeanDefinition>();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        TreeSet<String> beanTypeAndNames = new TreeSet<String>();
        if (StringUtils.isNotBlank((String)this.profileName)) {
            String[] profileNames;
            for (String profileName : profileNames = StringUtils.split((String)this.profileName, (char)',')) {
                if (!StringUtils.isNotBlank((String)(profileName = StringUtils.defaultIfBlank((String)profileName, (String)"").trim()))) continue;
                String fileToRead = "META-INF/plugin-components/profile-" + profileName.trim() + "/" + "component";
                beanTypeAndNames.addAll(AnnotationIndexReader.readAllIndexFilesForProduct(fileToRead, contextClassLoader, this.bundleContext));
            }
        } else {
            String fileToRead = "META-INF/plugin-components/component";
            beanTypeAndNames.addAll(AnnotationIndexReader.readAllIndexFilesForProduct(fileToRead, contextClassLoader, this.bundleContext));
        }
        for (String beanTypeAndName : beanTypeAndNames) {
            String[] typeAndName = StringUtils.split((String)beanTypeAndName, (String)"#");
            String beanClassName = typeAndName[0];
            String beanName = "";
            if (typeAndName.length > 1) {
                beanName = typeAndName[1];
            }
            if (StringUtils.isBlank((String)beanName)) {
                beanName = Introspector.decapitalize(ClassUtils.getShortName((String)beanClassName));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("Found candidate bean '%s' from class '%s'", beanName, beanClassName));
            }
            candidates.put(beanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition((String)beanClassName).getBeanDefinition());
        }
        return candidates;
    }

    protected void registerBeanDefinition(BeanDefinitionHolder definitionHolder, BeanDefinitionRegistry registry) {
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)definitionHolder, (BeanDefinitionRegistry)registry);
    }
}

