/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.extension;

import java.beans.PropertyDescriptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;

public class DevModeBeanInitialisationLoggerBeanPostProcessor
implements InstantiationAwareBeanPostProcessor {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final boolean isDevMode = Boolean.parseBoolean(System.getProperty("atlassian.dev.mode", "false"));
    private int recursionLevel = 0;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (isDevMode) {
            this.log.warn((Object)("AfterInitialisation [beanName=" + beanName + ", objectType=" + bean.getClass().getName() + ", level=" + this.recursionLevel + "]"));
            --this.recursionLevel;
        }
        return bean;
    }

    public Object postProcessBeforeInstantiation(Class beanClass, String beanName) throws BeansException {
        if (isDevMode) {
            ++this.recursionLevel;
            this.log.warn((Object)("BeforeInstantiation [beanName=" + beanName + ", objectType=" + beanClass.getName() + ", level=" + this.recursionLevel + "]"));
        }
        return null;
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        return true;
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        return pvs;
    }
}

