/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.annotations.Internal;
import com.atlassian.plugin.webresource.Config;
import com.atlassian.plugin.webresource.RequestCache;
import com.atlassian.plugin.webresource.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@Internal
public class Bundle {
    protected Config.Snapshot snapshot;
    private final String key;
    private final String version;
    private final boolean isTransformable;
    private final List<String> dependencies;
    private final Date updatedAt;
    private static Access ACCESS = new Access();

    public Bundle(Config.Snapshot snapshot, String key, List<String> dependencies, Date updatedAt, String version, boolean isTransformable) {
        this.snapshot = snapshot;
        this.key = key;
        this.dependencies = dependencies;
        this.updatedAt = updatedAt;
        this.version = version;
        this.isTransformable = isTransformable;
    }

    public String getKey() {
        return this.key;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isTransformable() {
        return this.isTransformable;
    }

    public boolean isCdnSupported() {
        return !this.hasLegacyConditions() && !this.snapshot.webResourcesWithLegacyTransformers.contains(this);
    }

    public boolean hasLegacyConditions() {
        return this.snapshot.webResourcesWithLegacyConditions.contains(this);
    }

    protected Config.Snapshot getSnapshot() {
        return this.snapshot;
    }

    public Map<String, Resource> getResources(RequestCache cache) {
        Map<String, Resource> resources = cache.getCachedResources(ACCESS).get(this);
        if (resources == null) {
            resources = this.snapshot.config.getResourcesWithoutCache(this);
            cache.getCachedResources(ACCESS).put(this, resources);
        }
        return resources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.key.equals(((Bundle)o).key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return "{" + this.key + (this.dependencies.isEmpty() ? "" : ", dependencies: " + StringUtils.join(this.dependencies, (String)",")) + "}";
    }

    public static class Access {
        private Access() {
        }
    }
}

