/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.components;

public final class HtmlEscaper {
    private static final String HTML_AMPERSAND = "&amp;";
    private static final String HTML_DOUBLE_QUOTE = "&quot;";
    private static final String HTML_GREATER_THAN = "&gt;";
    private static final String HTML_LEFT_SINGLE_QUOTE = "&lsquo;";
    private static final String HTML_LEFT_DOUBLE_QUOTE = "&ldquo;";
    private static final String HTML_LESS_THAN = "&lt;";
    private static final String HTML_RIGHT_SINGLE_QUOTE = "&rsquo;";
    private static final String HTML_RIGHT_DOUBLE_QUOTE = "&rdquo;";
    private static final String HTML_SINGLE_QUOTE = "&#39;";
    private static final CharMap ESCAPE_ALL_CHAR_MAP = new CharMap(){

        @Override
        public String get(char c) {
            switch (c) {
                case '\'': {
                    return HtmlEscaper.HTML_SINGLE_QUOTE;
                }
                case '\"': {
                    return HtmlEscaper.HTML_DOUBLE_QUOTE;
                }
                case '&': {
                    return HtmlEscaper.HTML_AMPERSAND;
                }
                case '>': {
                    return HtmlEscaper.HTML_GREATER_THAN;
                }
                case '<': {
                    return HtmlEscaper.HTML_LESS_THAN;
                }
                case '\u0091': {
                    return HtmlEscaper.HTML_LEFT_SINGLE_QUOTE;
                }
                case '\u0092': {
                    return HtmlEscaper.HTML_RIGHT_SINGLE_QUOTE;
                }
                case '\u0093': {
                    return HtmlEscaper.HTML_LEFT_DOUBLE_QUOTE;
                }
                case '\u0094': {
                    return HtmlEscaper.HTML_RIGHT_DOUBLE_QUOTE;
                }
            }
            return null;
        }
    };
    private static final CharMap ESCAPE_ALL_EXCEPT_QUOTES_CHAR_MAP = new CharMap(){

        @Override
        public String get(char c) {
            switch (c) {
                case '&': {
                    return HtmlEscaper.HTML_AMPERSAND;
                }
                case '>': {
                    return HtmlEscaper.HTML_GREATER_THAN;
                }
                case '<': {
                    return HtmlEscaper.HTML_LESS_THAN;
                }
                case '\u0091': {
                    return HtmlEscaper.HTML_LEFT_SINGLE_QUOTE;
                }
                case '\u0092': {
                    return HtmlEscaper.HTML_RIGHT_SINGLE_QUOTE;
                }
                case '\u0093': {
                    return HtmlEscaper.HTML_LEFT_DOUBLE_QUOTE;
                }
                case '\u0094': {
                    return HtmlEscaper.HTML_RIGHT_DOUBLE_QUOTE;
                }
            }
            return null;
        }
    };
    private static final CharMap ESCAPE_AMPERSAND_CHAR_MAP = new CharMap(){

        @Override
        public String get(char c) {
            return c != '&' ? null : HtmlEscaper.HTML_AMPERSAND;
        }
    };

    private HtmlEscaper() {
    }

    public static String escapeAll(String s, boolean preserveExistingEntities) {
        return HtmlEscaper.doReplacement(s, preserveExistingEntities, ESCAPE_ALL_CHAR_MAP);
    }

    public static String escapeAllExceptQuotes(String s, boolean preserveExistingEntities) {
        return HtmlEscaper.doReplacement(s, preserveExistingEntities, ESCAPE_ALL_EXCEPT_QUOTES_CHAR_MAP);
    }

    public static String escapeAmpersands(String s, boolean preserveExistingEntities) {
        return HtmlEscaper.doReplacement(s, preserveExistingEntities, ESCAPE_AMPERSAND_CHAR_MAP);
    }

    private static String doReplacement(String s, boolean preserveExistingEntities, CharMap charMap) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            String replacement = charMap.get(c);
            if (replacement == null) continue;
            if (!preserveExistingEntities) {
                return HtmlEscaper.escapeWithoutPreserveHeavy(s, charMap, i, replacement);
            }
            if (c == '&' && HtmlEscaper.entityAt(s, i)) continue;
            return HtmlEscaper.escapeWithPreserveHeavy(s, charMap, i, replacement);
        }
        return s;
    }

    private static String escapeWithoutPreserveHeavy(String s, CharMap charMap, int i, String replacement) {
        int len = s.length();
        StringBuilder sb = new StringBuilder(len + 64).append(s, 0, i).append(replacement);
        while (++i < len) {
            char c = s.charAt(i);
            replacement = charMap.get(c);
            if (replacement != null) {
                sb.append(replacement);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String escapeWithPreserveHeavy(String s, CharMap charMap, int i, String replacement) {
        int len = s.length();
        StringBuilder sb = new StringBuilder(len + 64).append(s, 0, i).append(replacement);
        while (++i < len) {
            char c = s.charAt(i);
            replacement = charMap.get(c);
            if (!(replacement == null || c == '&' && HtmlEscaper.entityAt(s, i))) {
                sb.append(replacement);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean entityAt(String s, int index) {
        char c;
        int stop = Math.min(s.length(), index + 10);
        if (index + 4 > stop) {
            return false;
        }
        if ((c = s.charAt(++index)) != '#' && !HtmlEscaper.isAlnum(c)) {
            return false;
        }
        if (!HtmlEscaper.isAlnum(s.charAt(++index))) {
            return false;
        }
        while (++index < stop) {
            c = s.charAt(index);
            if (HtmlEscaper.isAlnum(c)) continue;
            return c == ';';
        }
        return false;
    }

    private static boolean isAlnum(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    static interface CharMap {
        public String get(char var1);
    }
}

