/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.components;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.TokenType;
import com.atlassian.renderer.links.GenericLinkParser;
import com.atlassian.renderer.links.Link;
import com.atlassian.renderer.links.LinkResolver;
import com.atlassian.renderer.links.UnpermittedLink;
import com.atlassian.renderer.links.UnresolvedLink;
import com.atlassian.renderer.links.UrlLink;
import com.atlassian.renderer.util.UrlUtil;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.components.AbstractEmbeddedRendererComponent;
import com.atlassian.renderer.v2.components.AbstractRegexRendererComponent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlRendererComponent
extends AbstractRegexRendererComponent {
    @Deprecated
    public static Pattern URL_PATTERN = null;
    @Deprecated
    public static String PURE_URL_PATTERN = null;
    @Deprecated
    public static final char[] INVALID_END_CHARS = new char[]{'.', ',', '>', ')', ']', ';', '}', '\"', '\'', '!'};
    static final Pattern PATTERN;
    static final Pattern PATTERN_WITH_EMBED;
    private LinkResolver linkResolver;

    public UrlRendererComponent(LinkResolver linkResolver) {
        this.linkResolver = linkResolver;
    }

    @Override
    public boolean shouldRender(RenderMode renderMode) {
        return renderMode.renderLinks();
    }

    @Override
    public String render(String wiki, RenderContext context) {
        return wiki.indexOf(58) == -1 ? wiki : this.regexRender(wiki, context, PATTERN);
    }

    @Override
    public void appendSubstitution(StringBuffer buffer, RenderContext context, Matcher matcher) {
        int urlLen;
        int len;
        String url = matcher.group(2);
        for (len = urlLen = url.length(); len > 0 && UrlRendererComponent.isBadEndChar(url.charAt(len - 1)); --len) {
        }
        String fixedUrl = url.substring(0, len);
        Link link = this.linkResolver.createLink(context, fixedUrl);
        buffer.append(matcher.group(1));
        buffer.append(context.addRenderedContent(this.handleUrlLink(link, context, fixedUrl), TokenType.INLINE));
        if (urlLen > len) {
            buffer.append(url, len, urlLen);
        }
    }

    private static boolean isBadEndChar(char c) {
        switch (c) {
            case '!': 
            case '\"': 
            case '\'': 
            case ')': 
            case ',': 
            case '.': 
            case ';': 
            case '>': 
            case ']': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    public String handleUrlLink(Link link, RenderContext renderContext, String url) {
        renderContext.addExternalReference(new UrlLink(new GenericLinkParser(url)));
        if (link instanceof UnresolvedLink || link instanceof UnpermittedLink) {
            return url;
        }
        return renderContext.getLinkRenderer().renderLink(link, renderContext);
    }

    static {
        StringBuilder sb = new StringBuilder("(?<![\\p{Alnum}])((");
        for (String protocol : UrlUtil.URL_PROTOCOLS) {
            sb.append(protocol).append('|');
        }
        sb.setLength(sb.length() - 1);
        sb.append(")([-_.!~*';/?:@#&=%+$,\\p{Alnum}\\[\\]\\(\\)\\\\])+)");
        String regex = sb.toString();
        PATTERN = Pattern.compile("([^\"\\[\\|'!]|^)" + regex);
        PATTERN_WITH_EMBED = Pattern.compile(regex + "|" + AbstractEmbeddedRendererComponent.buildPhraseRegExp("\\!", "\\!"));
        PURE_URL_PATTERN = regex;
        URL_PATTERN = PATTERN;
    }
}

