/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.compat.clustered;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.compat.JobHandler;
import com.atlassian.scheduler.compat.JobHandlerKey;
import com.atlassian.scheduler.compat.JobInfo;
import com.atlassian.scheduler.compat.clustered.ClusteredCompatibilityPluginScheduler;
import com.atlassian.scheduler.config.IntervalScheduleInfo;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.util.concurrent.Assertions;

public class ClusteredJobRunner
implements JobRunner {
    private final JobHandler delegate;

    public ClusteredJobRunner(JobHandler delegate) {
        this.delegate = (JobHandler)Assertions.notNull((String)"delegate", (Object)delegate);
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        String jobKey = ClusteredCompatibilityPluginScheduler.toJobKey(request.getJobId());
        JobConfig jobConfig = request.getJobConfig();
        JobHandlerKey jobHandlerKey = ClusteredCompatibilityPluginScheduler.toJobHandlerKey(jobConfig.getJobRunnerKey());
        if (jobConfig.getRunMode() != RunMode.RUN_ONCE_PER_CLUSTER) {
            return JobRunnerResponse.aborted((String)("Job has unexpected run mode " + jobConfig.getRunMode()));
        }
        if (jobConfig.getSchedule().getType() != Schedule.Type.INTERVAL) {
            return JobRunnerResponse.aborted((String)("Job has unexpected schedule type " + jobConfig.getSchedule().getType()));
        }
        IntervalScheduleInfo interval = jobConfig.getSchedule().getIntervalScheduleInfo();
        JobInfo jobInfo = new JobInfo(jobKey, jobHandlerKey, interval.getFirstRunTime(), interval.getIntervalInMillis());
        this.delegate.execute(jobInfo);
        return JobRunnerResponse.success();
    }
}

