/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.core.util;

import com.atlassian.util.concurrent.Assertions;

public class TimeIntervalQuantizer {
    private static final int MILLIS_PER_MINUTE = 60000;

    public static long quantize(long intervalInMilliseconds, int resolution) {
        Assertions.isTrue((String)"intervalInMilliseconds cannot be negative", (intervalInMilliseconds >= 0L ? 1 : 0) != 0);
        if (resolution <= 1) {
            return intervalInMilliseconds;
        }
        long remainder = intervalInMilliseconds % (long)resolution;
        if (remainder == 0L) {
            return intervalInMilliseconds;
        }
        return TimeIntervalQuantizer.roundUpWithBoundsCheck(intervalInMilliseconds - remainder, resolution);
    }

    private static long roundUpWithBoundsCheck(long floor, int resolution) {
        if (floor >= Long.MAX_VALUE - (long)resolution) {
            return Long.MAX_VALUE;
        }
        return floor + (long)resolution;
    }

    public static long quantizeToMinutes(long intervalInMilliseconds) {
        return TimeIntervalQuantizer.quantize(intervalInMilliseconds, 60000);
    }
}

