/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.cookie;

import com.atlassian.security.cookie.ServerCookie;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public final class HttpOnlyCookies {
    private static final String COOKIE_HEADER = "Set-Cookie";

    private HttpOnlyCookies() {
    }

    public static void addHttpOnlyCookies(HttpServletResponse response, Cookie[] cookies) {
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                HttpOnlyCookies.addHttpOnlyCookie(response, cookie);
            }
        }
    }

    public static void addHttpOnlyCookie(HttpServletResponse response, Cookie cookie) {
        response.addHeader(COOKIE_HEADER, HttpOnlyCookies.generateCookieString(cookie));
    }

    private static String generateCookieString(Cookie cookie) {
        StringBuffer sb = new StringBuffer();
        ServerCookie.appendCookieValue(sb, cookie.getVersion(), cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getComment(), cookie.getMaxAge(), cookie.getSecure(), true);
        return sb.toString();
    }
}

