/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.concurrent;

import com.atlassian.util.concurrent.Assertions;
import com.atlassian.util.concurrent.Function;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WeakLockMap<D>
implements Function<D, Lock> {
    private final ConcurrentMap<D, LockReference<D>> locks;
    private final ReferenceQueue<Lock> queue = new ReferenceQueue();

    WeakLockMap(int initialCapacity) {
        this.locks = new ConcurrentHashMap<D, LockReference<D>>(initialCapacity);
    }

    @Override
    public Lock get(D descriptor) {
        this.expungeStaleEntries();
        Assertions.notNull("descriptor", descriptor);
        while (true) {
            LockReference reference;
            if ((reference = (LockReference)this.locks.get(descriptor)) != null) {
                Lock lock = (Lock)reference.get();
                if (lock != null) {
                    return lock;
                }
                this.locks.remove(descriptor, reference);
            }
            this.locks.putIfAbsent(descriptor, new LockReference<D>(descriptor, this.queue));
        }
    }

    private void expungeStaleEntries() {
        LockReference ref;
        while ((ref = (LockReference)this.queue.poll()) != null) {
            Object descriptor = ref.getDescriptor();
            if (descriptor == null) continue;
            this.locks.remove(descriptor, ref);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LockReference<D>
    extends WeakReference<Lock> {
        private final D descriptor;

        public LockReference(D descriptor, ReferenceQueue<? super Lock> q) {
            super(new ReentrantLock(), q);
            this.descriptor = Assertions.notNull("descriptor", descriptor);
        }

        final D getDescriptor() {
            return this.descriptor;
        }
    }
}

