/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache;

import com.atlassian.annotations.PublicApi;
import com.atlassian.vcache.VCacheException;
import java.util.Objects;
import javax.annotation.Nonnull;

@PublicApi
public class ExternalCacheException
extends VCacheException {
    private final Reason reason;

    public ExternalCacheException(Reason reason) {
        super("Failed due to " + reason.name());
        this.reason = Objects.requireNonNull(reason);
    }

    public ExternalCacheException(Reason reason, Throwable cause) {
        super("Failed due to " + reason.name(), cause);
        this.reason = Objects.requireNonNull(reason);
    }

    @Nonnull
    public Reason getReason() {
        return this.reason;
    }

    public static enum Reason {
        TIMEOUT,
        NETWORK_FAILURE,
        MARSHALLER_FAILURE,
        FUNCTION_INCORRECT_RESULT,
        CREATION_FAILURE,
        TRANSACTION_FAILURE,
        UNCLASSIFIED_FAILURE;

    }
}

