/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa.session;

import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.session.InvalidSessionHandleStateException;
import com.atomikos.datasource.xa.session.SessionHandleStateChangeListener;
import com.atomikos.datasource.xa.session.TransactionContext;
import com.atomikos.datasource.xa.session.UnexpectedTransactionContextException;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.transaction.xa.XAResource;

public class SessionHandleState {
    private static final Logger LOGGER = LoggerFactory.createLogger(SessionHandleState.class);
    private TransactionContext currentContext;
    private Set allContexts;
    private XATransactionalResource resource;
    private XAResource xaResource;
    private boolean erroneous;
    private boolean closed;
    private List sessionHandleStateChangeListeners = new ArrayList();

    public SessionHandleState(XATransactionalResource resource, XAResource xaResource) {
        this.resource = resource;
        this.xaResource = xaResource;
        this.allContexts = new HashSet();
        this.erroneous = false;
        this.closed = true;
    }

    public synchronized boolean isTerminated() {
        boolean terminated = true;
        Iterator it = this.allContexts.iterator();
        while (it.hasNext()) {
            TransactionContext b = (TransactionContext)it.next();
            if (b.isTerminated()) {
                it.remove();
                continue;
            }
            terminated = false;
        }
        if (terminated) {
            this.currentContext = null;
        }
        return terminated;
    }

    public synchronized void notifySessionBorrowed() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": notifySessionBorrowed");
        }
        this.currentContext = new TransactionContext(this.resource, this.xaResource);
        this.allContexts.add(this.currentContext);
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySessionClosed() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": entering notifySessionClosed");
        }
        boolean notifyOfClosedEvent = false;
        SessionHandleState sessionHandleState = this;
        synchronized (sessionHandleState) {
            boolean alreadyTerminated = this.isTerminated();
            for (TransactionContext b : this.allContexts) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebug(this + ": delegeting session close to " + b);
                }
                b.sessionClosed();
            }
            this.closed = true;
            if (this.isTerminated() && !alreadyTerminated) {
                notifyOfClosedEvent = true;
            }
        }
        if (notifyOfClosedEvent) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug(this + ": all contexts terminated, firing TerminatedEvent");
            }
            this.fireTerminatedEvent();
        }
    }

    public synchronized void notifyBeforeUse(CompositeTransaction ct, HeuristicMessage hmsg) throws InvalidSessionHandleStateException {
        block13: {
            if (this.closed) {
                throw new InvalidSessionHandleStateException("The underlying XA session is closed");
            }
            try {
                TransactionContext suspended = null;
                if (ct != null) {
                    Iterator it = this.allContexts.iterator();
                    while (it.hasNext() && suspended == null) {
                        TransactionContext b = (TransactionContext)it.next();
                        if (!b.isSuspendedInTransaction(ct)) continue;
                        suspended = b;
                    }
                }
                if (suspended != null) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.logInfo(this + ": resuming suspended XA context for transaction " + ct.getTid());
                    }
                    this.currentContext = suspended;
                    this.currentContext.transactionResumed();
                    break block13;
                }
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.logDebug(this + ": checking XA context for transaction " + ct);
                    }
                    this.currentContext.checkEnlistBeforeUse(ct, hmsg);
                }
                catch (UnexpectedTransactionContextException txBoundaryPassed) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.logInfo(this + ": suspending existing XA context and creating a new one for transaction " + ct);
                    }
                    this.currentContext.transactionSuspended();
                    this.currentContext = new TransactionContext(this.resource, this.xaResource);
                    this.allContexts.add(this.currentContext);
                    try {
                        this.currentContext.checkEnlistBeforeUse(ct, hmsg);
                    }
                    catch (UnexpectedTransactionContextException e) {
                        String msg = "Unexpected error in session handle";
                        LOGGER.logWarning(msg, (Throwable)e);
                        throw new InvalidSessionHandleStateException(msg);
                    }
                }
            }
            catch (InvalidSessionHandleStateException e) {
                this.notifySessionErrorOccurred();
                throw e;
            }
        }
    }

    public boolean isErroneous() {
        return this.erroneous;
    }

    public void notifySessionErrorOccurred() {
        this.erroneous = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTransactionTerminated(CompositeTransaction ct) {
        boolean notifyOfTerminatedEvent = false;
        SessionHandleState sessionHandleState = this;
        synchronized (sessionHandleState) {
            boolean alreadyTerminated = this.isTerminated();
            for (TransactionContext b : this.allContexts) {
                b.transactionTerminated(ct);
            }
            if (this.isTerminated() && !alreadyTerminated) {
                notifyOfTerminatedEvent = true;
            }
        }
        if (notifyOfTerminatedEvent) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug(this + ": all contexts terminated, firing TerminatedEvent for " + this);
            }
            this.fireTerminatedEvent();
        }
    }

    public void registerSessionHandleStateChangeListener(SessionHandleStateChangeListener listener) {
        this.sessionHandleStateChangeListeners.add(listener);
    }

    public void unregisterSessionHandleStateChangeListener(SessionHandleStateChangeListener listener) {
        this.sessionHandleStateChangeListeners.remove(listener);
    }

    private void fireTerminatedEvent() {
        for (int i = 0; i < this.sessionHandleStateChangeListeners.size(); ++i) {
            SessionHandleStateChangeListener listener = (SessionHandleStateChangeListener)this.sessionHandleStateChangeListeners.get(i);
            listener.onTerminated();
        }
    }

    public String toString() {
        return "a SessionHandleState with " + this.allContexts.size() + " context(s)";
    }

    public boolean isActiveInTransaction(CompositeTransaction tx) {
        boolean ret = false;
        if (this.currentContext != null && tx != null) {
            ret = this.currentContext.isInTransaction(tx);
        }
        return ret;
    }

    public boolean isInactiveInTransaction(CompositeTransaction tx) {
        boolean ret = false;
        if (this.currentContext != null && tx != null) {
            ret = this.currentContext.isInactiveInTransaction(tx);
        }
        return ret;
    }
}

