/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa.session;

import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.session.InvalidSessionHandleStateException;
import com.atomikos.datasource.xa.session.NotInBranchStateHandler;
import com.atomikos.datasource.xa.session.TerminatedStateHandler;
import com.atomikos.datasource.xa.session.TransactionContextStateHandler;
import com.atomikos.datasource.xa.session.UnexpectedTransactionContextException;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import javax.transaction.xa.XAResource;

class TransactionContext {
    private static final Logger LOGGER = LoggerFactory.createLogger(TransactionContext.class);
    private TransactionContextStateHandler state;

    TransactionContext(XATransactionalResource resource, XAResource xaResource) {
        this.setState(new NotInBranchStateHandler(resource, xaResource));
    }

    private synchronized void setState(TransactionContextStateHandler state) {
        if (state != null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace(this + ": changing to state " + state);
            }
            this.state = state;
        }
    }

    synchronized boolean isTerminated() {
        return this.state instanceof TerminatedStateHandler;
    }

    synchronized void checkEnlistBeforeUse(CompositeTransaction ct) throws InvalidSessionHandleStateException, UnexpectedTransactionContextException {
        TransactionContextStateHandler nextState = this.state.checkEnlistBeforeUse(ct);
        this.setState(nextState);
    }

    synchronized void sessionClosed() {
        TransactionContextStateHandler nextState = this.state.sessionClosed();
        this.setState(nextState);
    }

    synchronized void transactionSuspended() throws InvalidSessionHandleStateException {
        TransactionContextStateHandler nextState = this.state.transactionSuspended();
        this.setState(nextState);
    }

    synchronized void transactionResumed() throws InvalidSessionHandleStateException {
        TransactionContextStateHandler nextState = this.state.transactionResumed();
        this.setState(nextState);
    }

    synchronized void transactionTerminated(CompositeTransaction ct) {
        TransactionContextStateHandler nextState = this.state.transactionTerminated(ct);
        this.setState(nextState);
    }

    synchronized boolean isSuspendedInTransaction(CompositeTransaction ct) {
        return this.state.isSuspendedInTransaction(ct);
    }

    public String toString() {
        return "a TransactionContext in state " + this.state;
    }

    boolean isInTransaction(CompositeTransaction tx) {
        return this.state.isInTransaction(tx);
    }

    boolean isInactiveInTransaction(CompositeTransaction tx) {
        return this.state.isInactiveInTransaction(tx);
    }
}

