/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta;

import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.util.SerializableObjectFactory;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.UserTransaction;
import java.io.Serializable;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;

public class J2eeTransactionManager
implements TransactionManager,
Serializable,
Referenceable,
UserTransaction {
    private static final long serialVersionUID = 8584376600562353607L;
    private transient TransactionManagerImp tm;

    private void checkSetup() throws SystemException {
        this.tm = (TransactionManagerImp)TransactionManagerImp.getTransactionManager();
        if (this.tm == null) {
            throw new RuntimeException("Transaction Service not running?");
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        this.checkSetup();
        this.tm.begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.checkSetup();
        this.tm.commit();
    }

    public int getStatus() throws SystemException {
        this.checkSetup();
        return this.tm.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        this.checkSetup();
        return this.tm.getTransaction();
    }

    public void resume(Transaction tx) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.checkSetup();
        this.tm.resume(tx);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.checkSetup();
        this.tm.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.checkSetup();
        this.tm.setRollbackOnly();
    }

    public void setTransactionTimeout(int secs) throws SystemException {
        this.checkSetup();
        this.tm.setTransactionTimeout(secs);
    }

    public Transaction suspend() throws SystemException {
        this.checkSetup();
        return this.tm.suspend();
    }

    @Override
    public Reference getReference() throws NamingException {
        return SerializableObjectFactory.createReference((Serializable)this);
    }
}

