/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.xa.session.SessionHandleState;
import com.atomikos.jms.ConsumerProducerSupport;
import com.atomikos.jms.HeuristicMessageConsumer;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

class AtomikosJmsMessageConsumerProxy
extends ConsumerProducerSupport
implements HeuristicMessageConsumer {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosJmsMessageConsumerProxy.class);
    private MessageConsumer delegate;

    public AtomikosJmsMessageConsumerProxy(MessageConsumer delegate, SessionHandleState state) {
        super(state);
        this.delegate = delegate;
    }

    protected MessageConsumer getDelegate() {
        return this.delegate;
    }

    public Message receive(String hmsg) throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": receive ( " + hmsg + " )...");
        }
        Message ret = null;
        try {
            this.enlist(hmsg);
            ret = this.delegate.receive();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": receive returning " + ret);
        }
        return ret;
    }

    public Message receive(long timeout, String hmsg) throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": receive ( " + timeout + " , " + hmsg + " )...");
        }
        Message ret = null;
        try {
            this.enlist(hmsg);
            ret = this.delegate.receive(timeout);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": receive returning " + ret);
        }
        return ret;
    }

    public Message receiveNoWait(String hmsg) throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": receiveNoWait ( " + hmsg + " )...");
        }
        Message ret = null;
        try {
            this.enlist(hmsg);
            ret = this.delegate.receiveNoWait();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": receiveNoWait returning " + ret);
        }
        return ret;
    }

    public void close() throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": close...");
        }
        try {
            this.delegate.close();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": close done.");
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": getMessageListener()...");
        }
        MessageListener ret = null;
        try {
            ret = this.delegate.getMessageListener();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": getMessageListener() returning " + ret);
        }
        return ret;
    }

    public String getMessageSelector() throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": getMessageSelector()...");
        }
        String ret = null;
        try {
            ret = this.delegate.getMessageSelector();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": getMessageSelector() returning " + ret);
        }
        return ret;
    }

    public Message receive() throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": receive()...");
        }
        Message ret = this.receive(null);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": receive() returning " + ret);
        }
        return ret;
    }

    public Message receive(long timeout) throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": receive ( " + timeout + " )...");
        }
        Message ret = this.receive(timeout, null);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": receive() returning " + ret);
        }
        return ret;
    }

    public Message receiveNoWait() throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": receiveNoWait()...");
        }
        Message ret = this.receiveNoWait(null);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": receiveNoWait() returning " + ret);
        }
        return ret;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": setMessageListener ( " + listener + " )...");
        }
        try {
            this.delegate.setMessageListener(listener);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": setMessageListener done.");
        }
    }

    public String toString() {
        return "atomikos MessageConsumer proxy for " + this.delegate;
    }
}

