/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.xa.session.InvalidSessionHandleStateException;
import com.atomikos.datasource.xa.session.SessionHandleState;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.AtomikosJMSException;
import com.atomikos.jms.AtomikosTransactionRequiredJMSException;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;

abstract class ConsumerProducerSupport {
    private static final Logger LOGGER = LoggerFactory.createLogger(ConsumerProducerSupport.class);
    private SessionHandleState state;

    protected ConsumerProducerSupport(SessionHandleState state) {
        this.state = state;
    }

    protected void handleException(Exception e) throws AtomikosJMSException {
        this.state.notifySessionErrorOccurred();
        AtomikosJMSException.throwAtomikosJMSException("Error in proxy", e);
    }

    protected CompositeTransactionManager getCompositeTransactionManager() {
        CompositeTransactionManager ret = null;
        ret = Configuration.getCompositeTransactionManager();
        return ret;
    }

    protected void enlist(String hmsg) throws JMSException {
        CompositeTransaction ct = null;
        CompositeTransactionManager ctm = this.getCompositeTransactionManager();
        boolean enlist = false;
        StringHeuristicMessage shmsg = new StringHeuristicMessage(hmsg);
        if (ctm != null && (ct = ctm.getCompositeTransaction()) != null && ct.getProperty("com.atomikos.icatch.jta.transaction") != null) {
            enlist = true;
        }
        if (enlist) {
            this.registerSynchronization(ct);
            try {
                this.state.notifyBeforeUse(ct, shmsg);
            }
            catch (InvalidSessionHandleStateException ex) {
                String msg = "error during enlist: " + ex.getMessage();
                LOGGER.logWarning(this + ": " + msg);
                AtomikosJMSException.throwAtomikosJMSException(msg, ex);
            }
        } else {
            String msg = "The JMS session you are using requires a JTA transaction context for the calling thread and none was found.\nPlease correct your code to do one of the following: \n1. start a JTA transaction if you want your JMS operations to be subject to JTA commit/rollback, or\n2. increase the maxPoolSize of the AtomikosConnectionFactoryBean to avoid transaction timeout while waiting for a connection, or\n3. create a non-transacted session and do session acknowledgment yourself, or\n4. set localTransactionMode to true so connection-level commit/rollback are enabled.";
            LOGGER.logWarning(this + ": " + msg);
            AtomikosTransactionRequiredJMSException.throwAtomikosTransactionRequiredJMSException(msg);
        }
    }

    private void registerSynchronization(CompositeTransaction ct) throws AtomikosJMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": detected transaction " + ct);
        }
        ct.registerSynchronization(new JmsRequeueSynchronization(ct));
    }

    private class JmsRequeueSynchronization
    implements Synchronization {
        private static final long serialVersionUID = 1L;
        private CompositeTransaction compositeTransaction;
        private boolean afterCompletionDone;
        private Map<TxState, Object> transactionStatesIndicatingConnectionReusability;

        public JmsRequeueSynchronization(CompositeTransaction compositeTransaction) {
            this.compositeTransaction = compositeTransaction;
            this.afterCompletionDone = false;
            this.transactionStatesIndicatingConnectionReusability = new HashMap<TxState, Object>();
            this.transactionStatesIndicatingConnectionReusability.put(TxState.TERMINATED, TxState.TERMINATED);
            this.transactionStatesIndicatingConnectionReusability.put(TxState.HEUR_ABORTED, TxState.HEUR_ABORTED);
            this.transactionStatesIndicatingConnectionReusability.put(TxState.HEUR_COMMITTED, TxState.HEUR_COMMITTED);
            this.transactionStatesIndicatingConnectionReusability.put(TxState.HEUR_HAZARD, TxState.HEUR_HAZARD);
            this.transactionStatesIndicatingConnectionReusability.put(TxState.HEUR_MIXED, TxState.HEUR_MIXED);
        }

        public void afterCompletion(Object txstate) {
            if (this.afterCompletionDone) {
                return;
            }
            if (this.transactionStatesIndicatingConnectionReusability.containsKey(txstate)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebug("JmsRequeueSynchronization: detected termination of transaction " + this.compositeTransaction);
                }
                ConsumerProducerSupport.this.state.notifyTransactionTerminated(this.compositeTransaction);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebug("JmsRequeueSynchronization: is in terminated state ? " + ConsumerProducerSupport.this.state.isTerminated());
                }
                this.afterCompletionDone = true;
            }
        }

        public void beforeCompletion() {
        }

        public boolean equals(Object other) {
            boolean ret = false;
            if (other instanceof JmsRequeueSynchronization) {
                JmsRequeueSynchronization o = (JmsRequeueSynchronization)other;
                ret = this.compositeTransaction.isSameTransaction(o.compositeTransaction);
            }
            return ret;
        }

        public int hashCode() {
            return this.compositeTransaction.hashCode();
        }
    }
}

