/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.tcc.rest;

import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.tcc.rest.ParticipantAdapterImp;
import com.atomikos.icatch.tcc.rest.TccParticipant;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.tcc.rest.Coordinator;
import com.atomikos.tcc.rest.ParticipantLink;
import com.atomikos.tcc.rest.Transaction;
import java.util.Calendar;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.xml.bind.DatatypeConverter;

@Consumes(value={"application/tcc+json"})
@Path(value="/coordinator")
public class CoordinatorImp
implements Coordinator {
    private static Logger LOGGER = LoggerFactory.createLogger(CoordinatorImp.class);
    private CompositeTransactionManager ctm;

    private CompositeTransactionManager getCompositeTransactionManager() {
        if (Configuration.getCompositeTransactionManager() == null) {
            LOGGER.logWarning("Transaction core not yet initialized - initializing now, but should be done before!");
            Configuration.init();
        }
        if (this.ctm == null) {
            this.ctm = Configuration.getCompositeTransactionManager();
        }
        return this.ctm;
    }

    private CompositeTransaction createTaasTransaction(Transaction transaction) {
        CompositeTransaction ct = null;
        try {
            ct = this.convertToCompositeTransaction(transaction);
        }
        catch (Exception e) {
            LOGGER.logError("Unexpected error while creating transaction", (Throwable)e);
            throw new WebApplicationException(500);
        }
        return ct;
    }

    private CompositeTransaction convertToCompositeTransaction(Transaction transaction) {
        long timeout = this.deriveTimeout(transaction);
        CompositeTransaction ct = this.getCompositeTransactionManager().createCompositeTransaction(timeout);
        for (ParticipantLink pl : transaction.getParticipantLinks()) {
            ParticipantAdapterImp pa = new ParticipantAdapterImp(pl);
            TccParticipant p = new TccParticipant(pa);
            ct.addParticipant((Participant)p);
        }
        return ct;
    }

    private long deriveTimeout(Transaction transaction) {
        long timeout = 10000L;
        long now = System.currentTimeMillis();
        for (ParticipantLink pl : transaction.getParticipantLinks()) {
            long expires = this.toTimestamp(pl.getExpires());
            long participantTimeout = expires - now;
            if (participantTimeout <= timeout) continue;
            timeout = participantTimeout;
        }
        return timeout;
    }

    private long toTimestamp(String expires) {
        Calendar cal = DatatypeConverter.parseDateTime((String)expires);
        return cal.getTimeInMillis();
    }

    @PUT
    @Path(value="/confirm")
    public void confirm(Transaction transaction) {
        this.validateRequestIntegrity(transaction);
        CompositeTransaction taasTransaction = this.createTaasTransaction(transaction);
        this.commitTransaction(taasTransaction);
    }

    private void validateRequestIntegrity(Transaction transaction) {
        if (transaction == null) {
            this.failWithInvalidRequest("transaction must not be null");
        }
        for (ParticipantLink pl : transaction.getParticipantLinks()) {
            this.validateParticipantLink(pl);
        }
    }

    private void validateParticipantLink(ParticipantLink pl) {
        if (pl.getExpires() == null) {
            this.failWithInvalidRequest("each participantLink must have an 'expires'");
        }
        try {
            this.toTimestamp(pl.getExpires());
        }
        catch (IllegalArgumentException e) {
            this.failWithInvalidRequest("invalid date format for participantLink 'expires': " + pl.getExpires());
        }
        if (pl.getUri() == null) {
            this.failWithInvalidRequest("each participantLink must have a value for 'uri'");
        }
    }

    private void failWithInvalidRequest(String message) {
        LOGGER.logWarning(message);
        Response response = Response.status((int)400).entity((Object)message).type("text/plain").build();
        throw new WebApplicationException(response);
    }

    private void commitTransaction(CompositeTransaction taasTransaction) {
        try {
            taasTransaction.commit();
        }
        catch (SecurityException e) {
            this.throwCancelledException();
        }
        catch (RollbackException e) {
            this.throwCancelledException();
        }
        catch (HeurRollbackException e) {
            this.throwCancelledException();
        }
        catch (Exception e) {
            LOGGER.logError("Unexpected error during confirm", (Throwable)e);
            Response response = Response.status((int)409).entity((Object)"partial confirmation - check each participant for details").type("text/plain").build();
            throw new WebApplicationException(response);
        }
    }

    private void throwCancelledException() {
        Response response = Response.status((int)404).entity((Object)"transaction has timed out and was cancelled").type("text/plain").build();
        throw new WebApplicationException(response);
    }

    @PUT
    @Path(value="/cancel")
    public void cancel(Transaction transaction) {
        this.validateRequestIntegrity(transaction);
        CompositeTransaction taasTransaction = this.createTaasTransaction(transaction);
        this.rollbackTransaction(taasTransaction);
    }

    private void rollbackTransaction(CompositeTransaction taasTransaction) {
        try {
            taasTransaction.rollback();
        }
        catch (Exception e) {
            LOGGER.logWarning("Unexpected error during rollback", (Throwable)e);
        }
    }
}

