/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.tcc.rest;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.tcc.rest.ParticipantAdapter;
import java.util.Map;

class TccParticipant
implements Participant {
    private static final long serialVersionUID = 1L;
    private ParticipantAdapter resource;

    public TccParticipant(ParticipantAdapter resource) {
        this.resource = resource;
    }

    public String getURI() {
        return this.resource.getUri();
    }

    public void setCascadeList(Map<String, Integer> allParticipants) throws SysException {
    }

    public void setGlobalSiblingCount(int count) {
    }

    public int prepare() throws RollbackException, HeurHazardException, HeurMixedException, SysException {
        long roundTripTime = this.checkRoundtripTime();
        if (this.insufficientTimeLeft(roundTripTime)) {
            throw new RollbackException("Insufficient time left to confirm");
        }
        return 1;
    }

    private boolean insufficientTimeLeft(long roundTripTime) {
        long now = System.currentTimeMillis();
        return now + 2L * roundTripTime > this.getExpiryDateTime();
    }

    private long getExpiryDateTime() {
        return this.resource.getExpires();
    }

    private long checkRoundtripTime() {
        long start = System.currentTimeMillis();
        this.resource.options();
        long end = System.currentTimeMillis();
        return end - start;
    }

    public void commit(boolean onePhase) throws HeurRollbackException, HeurHazardException, HeurMixedException, RollbackException, SysException {
        this.resource.put();
    }

    public void rollback() throws HeurCommitException, HeurMixedException, HeurHazardException, SysException {
        this.resource.delete();
    }

    public void forget() {
    }

    public String toString() {
        return this.getURI();
    }

    public boolean isRecoverable() {
        return true;
    }

    public String getResourceName() {
        return null;
    }
}

