/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.tcc.rest;

import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.tcc.rest.Transaction;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;

@Consumes(value={"application/tcc+json"})
@Produces(value={"application/tcc+json"})
@Provider
public class TransactionProvider
implements MessageBodyWriter<Transaction>,
MessageBodyReader<Transaction> {
    private static final Logger LOGGER = LoggerFactory.createLogger(TransactionProvider.class);
    @Context
    protected Providers providers;

    public long getSize(Transaction l, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return Transaction.class.isAssignableFrom(type);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Transaction.class.isAssignableFrom(type);
    }

    public Transaction readFrom(Class<Transaction> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        MediaType realMediaType = MediaType.APPLICATION_JSON_TYPE;
        MessageBodyReader reader = this.providers.getMessageBodyReader(type, genericType, annotations, realMediaType);
        InputStream in = entityStream;
        if (LOGGER.isTraceEnabled()) {
            String content = this.getStringFromInputStream(entityStream);
            LOGGER.logTrace("Incoming REST request payload:\n" + content);
            in = new ByteArrayInputStream(content.getBytes());
        }
        return (Transaction)reader.readFrom(type, genericType, annotations, realMediaType, httpHeaders, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringFromInputStream(InputStream is) {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            LOGGER.logTrace("Failed to read REST payload.", (Throwable)e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
        return sb.toString();
    }

    public void writeTo(Transaction t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        MediaType realMediaType = MediaType.APPLICATION_JSON_TYPE;
        MessageBodyWriter writer = this.providers.getMessageBodyWriter(Transaction.class, genericType, annotations, realMediaType);
        writer.writeTo((Object)t, type, genericType, annotations, realMediaType, httpHeaders, entityStream);
    }
}

