/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp.thread;

import com.atomikos.icatch.system.Configuration;

final class ThreadFactory {
    static final ThreadFactory singleton = new ThreadFactory("Atomikos");
    private final String name;
    private int count;
    private final ThreadGroup group;

    static ThreadFactory getInstance() {
        return singleton;
    }

    private ThreadFactory(String threadBaseName) {
        SecurityManager sm = System.getSecurityManager();
        this.group = sm != null ? sm.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.name = threadBaseName;
    }

    String getBaseName() {
        return this.name;
    }

    Thread newThread(Runnable r) {
        String realName = this.name + ":" + this.incCount();
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug("ThreadFactory: creating new thread: " + realName);
        }
        Thread thread = new Thread(this.group, r, realName);
        thread.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        thread.setDaemon(true);
        return thread;
    }

    private synchronized int incCount() {
        return this.count++;
    }
}

