/*
 * Decompiled with CFR 0.152.
 */
package com.audienceproject.spark.dynamodb.datasource;

import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.audienceproject.spark.dynamodb.connector.ColumnSchema;
import com.audienceproject.spark.dynamodb.connector.TableConnector;
import com.audienceproject.spark.dynamodb.datasource.DynamoDataDeleteWriter;
import com.audienceproject.spark.dynamodb.datasource.DynamoDataUpdateWriter;
import com.audienceproject.spark.dynamodb.datasource.DynamoDataWriter;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.write.DataWriter;
import org.apache.spark.sql.connector.write.DataWriterFactory;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001\u0002\n\u0014\u0001yA\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!AA\n\u0001B\u0001B\u0003%Q\nC\u0003T\u0001\u0011\u0005A\u000bC\u0004[\u0001\t\u0007I\u0011B.\t\r\u0001\u0004\u0001\u0015!\u0003]\u0011\u001d\t\u0007A1A\u0005\n\tDaA\u001a\u0001!\u0002\u0013\u0019\u0007bB4\u0001\u0005\u0004%IA\u0019\u0005\u0007Q\u0002\u0001\u000b\u0011B2\t\u000f%\u0004!\u0019!C\u0005U\"1a\u000e\u0001Q\u0001\n-Dqa\u001c\u0001C\u0002\u0013%!\u000e\u0003\u0004q\u0001\u0001\u0006Ia\u001b\u0005\bc\u0002\u0011\r\u0011\"\u0003k\u0011\u0019\u0011\b\u0001)A\u0005W\")1\u000f\u0001C!i\n\u0019B)\u001f8b[><&/\u001b;fe\u001a\u000b7\r^8ss*\u0011A#F\u0001\u000bI\u0006$\u0018m]8ve\u000e,'B\u0001\f\u0018\u0003!!\u0017P\\1n_\u0012\u0014'B\u0001\r\u001a\u0003\u0015\u0019\b/\u0019:l\u0015\tQ2$A\bbk\u0012LWM\\2faJ|'.Z2u\u0015\u0005a\u0012aA2p[\u000e\u00011c\u0001\u0001 OA\u0011\u0001%J\u0007\u0002C)\u0011!eI\u0001\u0005Y\u0006twMC\u0001%\u0003\u0011Q\u0017M^1\n\u0005\u0019\n#AB(cU\u0016\u001cG\u000f\u0005\u0002)i5\t\u0011F\u0003\u0002+W\u0005)qO]5uK*\u0011A&L\u0001\nG>tg.Z2u_JT!AL\u0018\u0002\u0007M\fHN\u0003\u0002\u0019a)\u0011\u0011GM\u0001\u0007CB\f7\r[3\u000b\u0003M\n1a\u001c:h\u0013\t)\u0014FA\tECR\fwK]5uKJ4\u0015m\u0019;pef\u0004\"aN\u001d\u000e\u0003aR!\u0001L\u000b\n\u0005iB$A\u0004+bE2,7i\u001c8oK\u000e$xN]\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\b\u0003B\u001fG\u0013&s!A\u0010#\u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005k\u0012A\u0002\u001fs_>$hHC\u0001D\u0003\u0015\u00198-\u00197b\u0013\t)%)\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000f\"\u00131!T1q\u0015\t)%\t\u0005\u0002>\u0015&\u00111\n\u0013\u0002\u0007'R\u0014\u0018N\\4\u0002\rM\u001c\u0007.Z7b!\tq\u0015+D\u0001P\u0015\t\u0001V&A\u0003usB,7/\u0003\u0002S\u001f\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\rqJg.\u001b;?)\u0011)v\u000bW-\u0011\u0005Y\u0003Q\"A\n\t\u000b1\"\u0001\u0019\u0001\u001c\t\u000bm\"\u0001\u0019\u0001\u001f\t\u000b1#\u0001\u0019A'\u0002\u0013\t\fGo\u00195TSj,W#\u0001/\u0011\u0005usV\"\u0001\"\n\u0005}\u0013%aA%oi\u0006Q!-\u0019;dQNK'0\u001a\u0011\u0002\rU\u0004H-\u0019;f+\u0005\u0019\u0007CA/e\u0013\t)'IA\u0004C_>dW-\u00198\u0002\u000fU\u0004H-\u0019;fA\u00051A-\u001a7fi\u0016\fq\u0001Z3mKR,\u0007%\u0001\u0004sK\u001eLwN\\\u000b\u0002WB\u0019Q\f\\%\n\u00055\u0014%AB(qi&|g.A\u0004sK\u001eLwN\u001c\u0011\u0002\u000fI|G.Z!s]\u0006A!o\u001c7f\u0003Jt\u0007%A\tqe>4\u0018\u000eZ3s\u00072\f7o\u001d(b[\u0016\f!\u0003\u001d:pm&$WM]\"mCN\u001ch*Y7fA\u0005a1M]3bi\u0016<&/\u001b;feR!QO`A\u0001!\rAc\u000f_\u0005\u0003o&\u0012!\u0002R1uC^\u0013\u0018\u000e^3s!\tIH0D\u0001{\u0015\tYX&\u0001\u0005dCR\fG._:u\u0013\ti(PA\u0006J]R,'O\\1m%><\b\"B@\u0012\u0001\u0004a\u0016a\u00039beRLG/[8o\u0013\u0012Dq!a\u0001\u0012\u0001\u0004\t)!\u0001\u0004uCN\\\u0017\n\u001a\t\u0004;\u0006\u001d\u0011bAA\u0005\u0005\n!Aj\u001c8h\u0001")
public class DynamoWriterFactory
implements DataWriterFactory {
    private final TableConnector connector;
    private final StructType schema;
    private final int batchSize;
    private final boolean update;
    private final boolean delete;
    private final Option<String> region;
    private final Option<String> roleArn;
    private final Option<String> providerClassName;

    private int batchSize() {
        return this.batchSize;
    }

    private boolean update() {
        return this.update;
    }

    private boolean delete() {
        return this.delete;
    }

    private Option<String> region() {
        return this.region;
    }

    private Option<String> roleArn() {
        return this.roleArn;
    }

    private Option<String> providerClassName() {
        return this.providerClassName;
    }

    public DataWriter<InternalRow> createWriter(int partitionId, long taskId) {
        Object object;
        ColumnSchema columnSchema = new ColumnSchema(this.connector.keySchema(), this.schema);
        DynamoDB client = this.connector.getDynamoDB(this.region(), this.roleArn(), this.providerClassName());
        if (this.update()) {
            Predef$.MODULE$.assert(!this.delete(), (Function0 & java.io.Serializable & Serializable)() -> "Please provide exactly one of 'update' or 'delete' options.");
            object = new DynamoDataUpdateWriter(columnSchema, this.connector, client);
        } else {
            object = this.delete() ? new DynamoDataDeleteWriter(this.batchSize(), columnSchema, this.connector, client) : new DynamoDataWriter(this.batchSize(), columnSchema, this.connector, client);
        }
        return object;
    }

    public DynamoWriterFactory(TableConnector connector, Map<String, String> parameters, StructType schema) {
        this.connector = connector;
        this.schema = schema;
        this.batchSize = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)"writebatchsize", (Function0 & java.io.Serializable & Serializable)() -> "25"))).toInt();
        this.update = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)"update", (Function0 & java.io.Serializable & Serializable)() -> "false"))).toBoolean();
        this.delete = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)"delete", (Function0 & java.io.Serializable & Serializable)() -> "false"))).toBoolean();
        this.region = parameters.get((Object)"region");
        this.roleArn = parameters.get((Object)"rolearn");
        this.providerClassName = parameters.get((Object)"providerclassname");
    }
}

