/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt;

import com.auth0.jwt.JWTAudienceException;
import com.auth0.jwt.JWTExpiredException;
import com.auth0.jwt.JWTIssuerException;
import com.auth0.jwt.JWTVerifyException;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.JsonNode;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.ObjectMapper;
import com.auth0.jwt.internal.org.apache.commons.codec.binary.Base64;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JWTVerifier {
    private final byte[] secret;
    private final String audience;
    private final String issuer;
    private final Base64 decoder = new Base64(true);
    private final ObjectMapper mapper;
    private Map<String, String> algorithms;

    public JWTVerifier(String secret, String audience, String issuer) {
        this(secret.getBytes(Charset.forName("UTF-8")), audience, issuer);
    }

    public JWTVerifier(String secret, String audience) {
        this(secret, audience, null);
    }

    public JWTVerifier(String secret) {
        this(secret, null, null);
    }

    public JWTVerifier(byte[] secret, String audience, String issuer) {
        if (secret == null || secret.length == 0) {
            throw new IllegalArgumentException("Secret cannot be null or empty");
        }
        this.mapper = new ObjectMapper();
        this.algorithms = new HashMap<String, String>();
        this.algorithms.put("HS256", "HmacSHA256");
        this.algorithms.put("HS384", "HmacSHA384");
        this.algorithms.put("HS512", "HmacSHA512");
        this.secret = secret;
        this.audience = audience;
        this.issuer = issuer;
    }

    public JWTVerifier(byte[] secret, String audience) {
        this(secret, audience, null);
    }

    public JWTVerifier(byte[] secret) {
        this(secret, null, null);
    }

    public Map<String, Object> verify(String token) throws NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IOException, SignatureException, JWTVerifyException {
        if (token == null || "".equals(token)) {
            throw new IllegalStateException("token not set");
        }
        String[] pieces = token.split("\\.");
        if (pieces.length != 3) {
            throw new IllegalStateException("Wrong number of segments: " + pieces.length);
        }
        JsonNode jwtHeader = this.decodeAndParse(pieces[0]);
        String algorithm = this.getAlgorithm(jwtHeader);
        JsonNode jwtPayload = this.decodeAndParse(pieces[1]);
        this.verifySignature(pieces, algorithm);
        this.verifyExpiration(jwtPayload);
        this.verifyIssuer(jwtPayload);
        this.verifyAudience(jwtPayload);
        return this.mapper.treeToValue(jwtPayload, Map.class);
    }

    void verifySignature(String[] pieces, String algorithm) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Mac hmac = Mac.getInstance(algorithm);
        hmac.init(new SecretKeySpec(this.secret, algorithm));
        byte[] sig = hmac.doFinal((pieces[0] + "." + pieces[1]).getBytes());
        if (!Arrays.equals(sig, Base64.decodeBase64(pieces[2]))) {
            throw new SignatureException("signature verification failed");
        }
    }

    void verifyExpiration(JsonNode jwtClaims) throws JWTExpiredException {
        long expiration;
        long l = expiration = jwtClaims.has("exp") ? jwtClaims.get("exp").asLong(0L) : 0L;
        if (expiration != 0L && System.currentTimeMillis() / 1000L >= expiration) {
            throw new JWTExpiredException("jwt expired", expiration);
        }
    }

    void verifyIssuer(JsonNode jwtClaims) throws JWTIssuerException {
        String issuerFromToken;
        String string = issuerFromToken = jwtClaims.has("iss") ? jwtClaims.get("iss").asText() : null;
        if (issuerFromToken != null && this.issuer != null && !this.issuer.equals(issuerFromToken)) {
            throw new JWTIssuerException("jwt issuer invalid", issuerFromToken);
        }
    }

    void verifyAudience(JsonNode jwtClaims) throws JWTAudienceException {
        if (this.audience == null) {
            return;
        }
        JsonNode audNode = jwtClaims.get("aud");
        if (audNode == null) {
            return;
        }
        if (audNode.isArray()) {
            for (JsonNode jsonNode : audNode) {
                if (!this.audience.equals(jsonNode.textValue())) continue;
                return;
            }
        } else if (audNode.isTextual() && this.audience.equals(audNode.textValue())) {
            return;
        }
        throw new JWTAudienceException("jwt audience invalid", audNode);
    }

    String getAlgorithm(JsonNode jwtHeader) {
        String algorithmName;
        String string = algorithmName = jwtHeader.has("alg") ? jwtHeader.get("alg").asText() : null;
        if (jwtHeader.get("alg") == null) {
            throw new IllegalStateException("algorithm not set");
        }
        if (this.algorithms.get(algorithmName) == null) {
            throw new IllegalStateException("unsupported algorithm");
        }
        return this.algorithms.get(algorithmName);
    }

    JsonNode decodeAndParse(String b64String) throws IOException {
        String jsonString = new String(Base64.decodeBase64(b64String), "UTF-8");
        JsonNode jwtHeader = this.mapper.readValue(jsonString, JsonNode.class);
        return jwtHeader;
    }
}

