/*
 * Decompiled with CFR 0.152.
 */
package com.auth0;

import com.auth0.AlgorithmNameVerifier;
import com.auth0.AsymmetricSignatureVerifier;
import com.auth0.AuthorizeUrl;
import com.auth0.IdTokenVerifier;
import com.auth0.IdentityVerificationException;
import com.auth0.RequestProcessor;
import com.auth0.SignatureVerifier;
import com.auth0.StorageUtils;
import com.auth0.SymmetricSignatureVerifier;
import com.auth0.Tokens;
import com.auth0.client.auth.AuthAPI;
import com.auth0.jwk.JwkProvider;
import com.auth0.net.Telemetry;
import com.google.common.annotations.VisibleForTesting;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.Validate;

public class AuthenticationController {
    private final RequestProcessor requestProcessor;

    @VisibleForTesting
    AuthenticationController(RequestProcessor requestProcessor) {
        this.requestProcessor = requestProcessor;
    }

    @VisibleForTesting
    RequestProcessor getRequestProcessor() {
        return this.requestProcessor;
    }

    public static Builder newBuilder(String domain, String clientId, String clientSecret) {
        return new Builder(domain, clientId, clientSecret);
    }

    public void setLoggingEnabled(boolean enabled) {
        this.requestProcessor.getClient().setLoggingEnabled(enabled);
    }

    public void doNotSendTelemetry() {
        this.requestProcessor.getClient().doNotSendTelemetry();
    }

    public Tokens handle(HttpServletRequest request, HttpServletResponse response) throws IdentityVerificationException {
        Validate.notNull((Object)request, (String)"request must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)response, (String)"response must not be null", (Object[])new Object[0]);
        return this.requestProcessor.process(request, response);
    }

    @Deprecated
    public Tokens handle(HttpServletRequest request) throws IdentityVerificationException {
        Validate.notNull((Object)request, (String)"request must not be null", (Object[])new Object[0]);
        return this.requestProcessor.process(request, null);
    }

    @Deprecated
    public AuthorizeUrl buildAuthorizeUrl(HttpServletRequest request, String redirectUri) {
        Validate.notNull((Object)request, (String)"request must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)redirectUri, (String)"redirectUri must not be null", (Object[])new Object[0]);
        String state = StorageUtils.secureRandomString();
        String nonce = StorageUtils.secureRandomString();
        return this.requestProcessor.buildAuthorizeUrl(request, null, redirectUri, state, nonce);
    }

    public AuthorizeUrl buildAuthorizeUrl(HttpServletRequest request, HttpServletResponse response, String redirectUri) {
        Validate.notNull((Object)request, (String)"request must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)response, (String)"response must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)redirectUri, (String)"redirectUri must not be null", (Object[])new Object[0]);
        String state = StorageUtils.secureRandomString();
        String nonce = StorageUtils.secureRandomString();
        return this.requestProcessor.buildAuthorizeUrl(request, response, redirectUri, state, nonce);
    }

    public static class Builder {
        private static final String RESPONSE_TYPE_CODE = "code";
        private final String domain;
        private final String clientId;
        private final String clientSecret;
        private String responseType;
        private JwkProvider jwkProvider;
        private Integer clockSkew;
        private Integer authenticationMaxAge;
        private boolean useLegacySameSiteCookie;

        Builder(String domain, String clientId, String clientSecret) {
            Validate.notNull((Object)domain);
            Validate.notNull((Object)clientId);
            Validate.notNull((Object)clientSecret);
            this.domain = domain;
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.responseType = RESPONSE_TYPE_CODE;
            this.useLegacySameSiteCookie = true;
        }

        public Builder withResponseType(String responseType) {
            Validate.notNull((Object)responseType);
            this.responseType = responseType.trim().toLowerCase();
            return this;
        }

        public Builder withJwkProvider(JwkProvider jwkProvider) {
            Validate.notNull((Object)jwkProvider);
            this.jwkProvider = jwkProvider;
            return this;
        }

        public Builder withClockSkew(Integer clockSkew) {
            Validate.notNull((Object)clockSkew);
            this.clockSkew = clockSkew;
            return this;
        }

        public Builder withAuthenticationMaxAge(Integer maxAge) {
            Validate.notNull((Object)maxAge);
            this.authenticationMaxAge = maxAge;
            return this;
        }

        public Builder withLegacySameSiteCookie(boolean useLegacySameSiteCookie) {
            this.useLegacySameSiteCookie = useLegacySameSiteCookie;
            return this;
        }

        public AuthenticationController build() throws UnsupportedOperationException {
            boolean expectedAlgorithmIsExplicitlySetAndAsymmetric;
            AuthAPI apiClient = this.createAPIClient(this.domain, this.clientId, this.clientSecret);
            this.setupTelemetry(apiClient);
            boolean bl = expectedAlgorithmIsExplicitlySetAndAsymmetric = this.jwkProvider != null;
            SignatureVerifier signatureVerifier = expectedAlgorithmIsExplicitlySetAndAsymmetric ? new AsymmetricSignatureVerifier(this.jwkProvider) : (this.responseType.contains(RESPONSE_TYPE_CODE) ? new AlgorithmNameVerifier() : new SymmetricSignatureVerifier(this.clientSecret));
            String issuer = this.getIssuer(this.domain);
            IdTokenVerifier.Options verifyOptions = this.createIdTokenVerificationOptions(issuer, this.clientId, signatureVerifier);
            verifyOptions.setClockSkew(this.clockSkew);
            verifyOptions.setMaxAge(this.authenticationMaxAge);
            RequestProcessor processor = new RequestProcessor(apiClient, this.responseType, verifyOptions, this.useLegacySameSiteCookie);
            return new AuthenticationController(processor);
        }

        @VisibleForTesting
        IdTokenVerifier.Options createIdTokenVerificationOptions(String issuer, String audience, SignatureVerifier signatureVerifier) {
            return new IdTokenVerifier.Options(issuer, audience, signatureVerifier);
        }

        @VisibleForTesting
        AuthAPI createAPIClient(String domain, String clientId, String clientSecret) {
            return new AuthAPI(domain, clientId, clientSecret);
        }

        @VisibleForTesting
        void setupTelemetry(AuthAPI client) {
            Telemetry telemetry = new Telemetry("auth0-java-mvc-common", this.obtainPackageVersion());
            client.setTelemetry(telemetry);
        }

        @VisibleForTesting
        String obtainPackageVersion() {
            return this.getClass().getPackage().getImplementationVersion();
        }

        private String getIssuer(String domain) {
            if (!domain.startsWith("http://") && !domain.startsWith("https://")) {
                domain = "https://" + domain;
            }
            if (!domain.endsWith("/")) {
                domain = domain + "/";
            }
            return domain;
        }
    }
}

