/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.model;

import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.RunResult;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.markuputils.Markup;
import com.aventstack.extentreports.model.AbstractStructure;
import com.aventstack.extentreports.model.BasicMongoReportElement;
import com.aventstack.extentreports.model.ExceptionInfo;
import com.aventstack.extentreports.model.ScreenCapture;
import com.aventstack.extentreports.model.Screencast;
import com.aventstack.extentreports.model.Test;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.bson.types.ObjectId;

public class Log
implements RunResult,
Serializable,
BasicMongoReportElement {
    private static final long serialVersionUID = 1594512136869286425L;
    private AbstractStructure<ScreenCapture> screenCaptureContext;
    private AbstractStructure<Screencast> screencastContext;
    private ExtentTest parent;
    private Test parentModel;
    private Markup markup;
    private Date timestamp = Calendar.getInstance().getTime();
    private Status logStatus;
    private String stepName;
    private String details;
    private int sequence;
    private ObjectId objectId;
    private ExceptionInfo exceptionInfo;

    public Log(Test test) {
        this.parentModel = test;
    }

    public Log(ExtentTest test) {
        this.parent = test;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public void setStatus(Status logStatus) {
        this.logStatus = logStatus;
    }

    @Override
    public Status getStatus() {
        return this.logStatus;
    }

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }

    public String getStepName() {
        return this.stepName;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public String getDetails() {
        return this.details;
    }

    public void setMarkup(Markup markup) {
        this.markup = markup;
    }

    public Markup getMarkup() {
        return this.markup;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setScreenCapture(ScreenCapture screenCapture) {
        if (this.screenCaptureContext == null) {
            this.screenCaptureContext = new AbstractStructure();
        }
        this.screenCaptureContext.add(screenCapture);
        screenCapture.setTestObjectId(this.getParent().getModel().getObjectId());
    }

    public AbstractStructure<ScreenCapture> getScreenCaptureContext() {
        return this.screenCaptureContext;
    }

    public boolean hasScreenCapture() {
        return this.screenCaptureContext != null && this.screenCaptureContext.size() > 0;
    }

    public void setScreencast(Screencast screencast) {
        if (this.screencastContext == null) {
            this.screencastContext = new AbstractStructure();
        }
        this.screencastContext.add(screencast);
    }

    public AbstractStructure<Screencast> getScreencastContext() {
        return this.screencastContext;
    }

    public boolean hasScreencast() {
        return this.screencastContext != null && this.screencastContext.size() > 0;
    }

    public ExtentTest getParent() {
        return this.parent;
    }

    public Test getParentModel() {
        return this.parent == null ? this.parentModel : this.parent.getModel();
    }

    @Override
    public ObjectId getObjectId() {
        return this.objectId;
    }

    @Override
    public void setObjectId(ObjectId id) {
        this.objectId = id;
    }

    public void setExceptionInfo(ExceptionInfo exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
    }

    public ExceptionInfo getExceptionInfo() {
        return this.exceptionInfo;
    }

    public String toString() {
        return "[log]  {timestamp: " + this.getTimestamp() + "," + " status: " + this.getStatus() + "," + " details: " + this.getDetails() + " }";
    }
}

