/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter;

import com.aventstack.extentreports.ReportAggregates;
import com.aventstack.extentreports.reporter.BasicFileReporter;
import com.aventstack.extentreports.reporter.configuration.ExtentLoggerFormatterConfiguration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExtentLoggerReporter
extends BasicFileReporter {
    private static final Logger logger = Logger.getLogger(ExtentLoggerReporter.class.getName());
    private static final String REPORTER_NAME = "logger";
    private static final String TEMPLATE_NAME = "logger/logger-test.ftl";
    private static final String DASHBOARD_TEMPLATE_NAME = "logger/logger-dashboard.ftl";
    private static final String CATEGORY_TEMPLATE_NAME = "logger/logger-tag.ftl";
    private static final String EXCEPTION_TEMPLATE_NAME = "logger/logger-exception.ftl";
    private static final String[] DEFAULT_CONFIG_FILE_PATH = new String[]{"logger.properties", "src/main/resources/logger.properties"};
    private ExtentLoggerFormatterConfiguration userConfig = new ExtentLoggerFormatterConfiguration(this);

    public ExtentLoggerReporter(String path) {
        super(path);
        this.init(DEFAULT_CONFIG_FILE_PATH, this.config());
    }

    public ExtentLoggerReporter(File file) {
        super(file);
        this.init(DEFAULT_CONFIG_FILE_PATH, this.config());
    }

    public ExtentLoggerFormatterConfiguration config() {
        return this.userConfig;
    }

    @Override
    public synchronized void flush(ReportAggregates reportAggregates) {
        super.flush(reportAggregates);
        if (this.getTestList().isEmpty()) {
            return;
        }
        if (this.enforceOfflineMode().booleanValue()) {
            this.userConfig.enableOfflineMode(true);
        }
        this.loadUserConfig();
        try {
            Template template = this.getFreemarkerConfig().getTemplate(TEMPLATE_NAME);
            this.processTemplate(template, new File(String.valueOf(this.destination) + "index.html"));
            if (String.valueOf(this.configContext.getValue("enableDashboard")).equalsIgnoreCase("true")) {
                template = this.getFreemarkerConfig().getTemplate(DASHBOARD_TEMPLATE_NAME);
                this.processTemplate(template, new File(String.valueOf(this.destination) + "dashboard.html"));
            }
            if (!this.getCategoryContextInfo().getTestAttributeTestContextList().isEmpty()) {
                template = this.getFreemarkerConfig().getTemplate(CATEGORY_TEMPLATE_NAME);
                this.processTemplate(template, new File(String.valueOf(this.destination) + "tag.html"));
            }
            if (!this.getExceptionContextInfo().getExceptionTestContextList().isEmpty()) {
                template = this.getFreemarkerConfig().getTemplate(EXCEPTION_TEMPLATE_NAME);
                this.processTemplate(template, new File(String.valueOf(this.destination) + "exception.html"));
            }
        }
        catch (TemplateException | IOException e) {
            logger.log(Level.SEVERE, "An exception occurred", e);
        }
    }

    @Override
    public String getReporterName() {
        return REPORTER_NAME;
    }
}

