/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.config.external;

import com.aventstack.extentreports.config.ConfigStore;
import com.aventstack.extentreports.config.external.ConfigLoadable;
import com.aventstack.extentreports.config.external.JsonConfigLoader;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlConfigLoader<T>
implements ConfigLoadable<T> {
    private static final Logger LOG = Logger.getLogger(XmlConfigLoader.class.getName());
    private ConfigStore store = new ConfigStore();
    private InputStream stream;
    private T instance;

    public XmlConfigLoader(T instance, File f) {
        this.createStream(f);
        this.instance = instance;
    }

    private void createStream(File file) {
        try {
            this.stream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            LOG.log(Level.SEVERE, file.getPath(), e);
        }
    }

    @Override
    public void apply() {
        ConfigStore store = this.getConfigStore();
        Gson gson = new Gson();
        String json = gson.toJson(store.getStore());
        JsonConfigLoader<T> jsonLoader = new JsonConfigLoader<T>(this.instance, json);
        jsonLoader.apply();
    }

    public ConfigStore getConfigStore() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document doc = documentBuilder.parse(this.stream);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getElementsByTagName("configuration").item(0).getChildNodes();
            for (int ix = 0; ix < nodeList.getLength(); ++ix) {
                Element el;
                Node node = nodeList.item(ix);
                Element element = el = node.getNodeType() == 1 ? (Element)node : null;
                if (el == null) continue;
                String value = el.getTextContent();
                value = el instanceof CharacterData ? ((CharacterData)((Object)el)).getData() : value;
                this.store.addConfig(el.getNodeName(), value);
            }
            return this.store;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.log(Level.SEVERE, "Failed to load external configuration", e);
            return null;
        }
    }
}

