/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.models;

import com.azure.ai.formrecognizer.implementation.FormTableHelper;
import com.azure.ai.formrecognizer.models.FieldBoundingBox;
import com.azure.ai.formrecognizer.models.FormTableCell;
import java.util.Collections;
import java.util.List;

public final class FormTable {
    private final int rowCount;
    private final int columnCount;
    private final List<FormTableCell> cells;
    private final int pageNumber;
    private FieldBoundingBox boundingBox;

    public FormTable(int rowCount, int columnCount, List<FormTableCell> cells, int pageNumber) {
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.cells = cells == null ? null : Collections.unmodifiableList(cells);
        this.pageNumber = pageNumber;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public List<FormTableCell> getCells() {
        return this.cells;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    private FormTable setBoundingBox(FieldBoundingBox boundingBox) {
        this.boundingBox = boundingBox;
        return this;
    }

    public FieldBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    static {
        FormTableHelper.setAccessor(new FormTableHelper.FormTableAccessor(){

            @Override
            public void setBoundingBox(FormTable formTable, FieldBoundingBox boundingBox) {
                formTable.setBoundingBox(boundingBox);
            }
        });
    }
}

