/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.models;

import com.azure.ai.formrecognizer.implementation.Utility;
import com.azure.ai.formrecognizer.models.FormContentType;
import com.azure.ai.formrecognizer.models.FormRecognizerLocale;
import java.time.Duration;
import java.util.List;

public final class RecognizeReceiptsOptions {
    private FormContentType contentType;
    private boolean includeFieldElements;
    private FormRecognizerLocale locale;
    private List<String> pages;
    private Duration pollInterval = Utility.DEFAULT_POLL_INTERVAL;

    public FormContentType getContentType() {
        return this.contentType;
    }

    public boolean isFieldElementsIncluded() {
        return this.includeFieldElements;
    }

    public Duration getPollInterval() {
        return this.pollInterval;
    }

    public RecognizeReceiptsOptions setContentType(FormContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public RecognizeReceiptsOptions setFieldElementsIncluded(boolean includeFieldElements) {
        this.includeFieldElements = includeFieldElements;
        return this;
    }

    public RecognizeReceiptsOptions setPollInterval(Duration pollInterval) {
        this.pollInterval = pollInterval == null ? Utility.DEFAULT_POLL_INTERVAL : pollInterval;
        return this;
    }

    public FormRecognizerLocale getLocale() {
        return this.locale;
    }

    public RecognizeReceiptsOptions setLocale(FormRecognizerLocale locale) {
        this.locale = locale;
        return this;
    }

    public List<String> getPages() {
        return this.pages;
    }

    public RecognizeReceiptsOptions setPages(List<String> pages) {
        this.pages = pages;
        return this;
    }
}

