/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ContentFilterDetectionResult
implements JsonSerializable<ContentFilterDetectionResult> {
    private final boolean filtered;
    private final boolean detected;

    private ContentFilterDetectionResult(boolean filtered, boolean detected) {
        this.filtered = filtered;
        this.detected = detected;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public boolean isDetected() {
        return this.detected;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("filtered", this.filtered);
        jsonWriter.writeBooleanField("detected", this.detected);
        return jsonWriter.writeEndObject();
    }

    public static ContentFilterDetectionResult fromJson(JsonReader jsonReader) throws IOException {
        return (ContentFilterDetectionResult)jsonReader.readObject(reader -> {
            boolean filtered = false;
            boolean detected = false;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("filtered".equals(fieldName)) {
                    filtered = reader.getBoolean();
                    continue;
                }
                if ("detected".equals(fieldName)) {
                    detected = reader.getBoolean();
                    continue;
                }
                reader.skipChildren();
            }
            return new ContentFilterDetectionResult(filtered, detected);
        });
    }
}

