/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponseOutputTextAnnotationType;
import com.azure.ai.openai.responses.models.ResponsesOutputTextAnnotation;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesOutputTextAnnotationFilePath
extends ResponsesOutputTextAnnotation {
    private ResponseOutputTextAnnotationType type = ResponseOutputTextAnnotationType.FILE_PATH;
    private final String fileId;
    private final int index;

    public ResponsesOutputTextAnnotationFilePath(String fileId, int index) {
        this.fileId = fileId;
        this.index = index;
    }

    @Override
    public ResponseOutputTextAnnotationType getType() {
        return this.type;
    }

    public String getFileId() {
        return this.fileId;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("file_id", this.fileId);
        jsonWriter.writeIntField("index", this.index);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesOutputTextAnnotationFilePath fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesOutputTextAnnotationFilePath)jsonReader.readObject(reader -> {
            String fileId = null;
            int index = 0;
            ResponseOutputTextAnnotationType type = ResponseOutputTextAnnotationType.FILE_PATH;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("file_id".equals(fieldName)) {
                    fileId = reader.getString();
                    continue;
                }
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponseOutputTextAnnotationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesOutputTextAnnotationFilePath deserializedResponsesOutputTextAnnotationFilePath = new ResponsesOutputTextAnnotationFilePath(fileId, index);
            deserializedResponsesOutputTextAnnotationFilePath.type = type;
            return deserializedResponsesOutputTextAnnotationFilePath;
        });
    }
}

