/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponseTextOptions;
import com.azure.ai.openai.responses.models.ResponseTruncation;
import com.azure.ai.openai.responses.models.ResponsesError;
import com.azure.ai.openai.responses.models.ResponsesItem;
import com.azure.ai.openai.responses.models.ResponsesReasoningConfiguration;
import com.azure.ai.openai.responses.models.ResponsesResponseIncompleteDetails;
import com.azure.ai.openai.responses.models.ResponsesResponseStatus;
import com.azure.ai.openai.responses.models.ResponsesResponseUsage;
import com.azure.ai.openai.responses.models.ResponsesTool;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;

public final class ResponsesResponse
implements JsonSerializable<ResponsesResponse> {
    private final String id;
    private final String object = "response";
    private final long createdAt;
    private ResponsesResponseStatus status;
    private final ResponsesError error;
    private final ResponsesResponseIncompleteDetails incompleteDetails;
    private final String instructions;
    private Integer maxOutputTokens;
    private final String model;
    private final List<ResponsesItem> output;
    private final boolean parallelToolCalls;
    private final String previousResponseId;
    private ResponsesReasoningConfiguration reasoning;
    private final double temperature;
    private ResponseTextOptions text;
    private final BinaryData toolChoice;
    private final List<ResponsesTool> tools;
    private final double topP;
    private ResponseTruncation truncation;
    private ResponsesResponseUsage usage;
    private String user;
    private final Map<String, String> metadata;

    public String getId() {
        return this.id;
    }

    public String getObject() {
        return this.object;
    }

    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    public ResponsesResponseStatus getStatus() {
        return this.status;
    }

    public ResponsesError getError() {
        return this.error;
    }

    public ResponsesResponseIncompleteDetails getIncompleteDetails() {
        return this.incompleteDetails;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public Integer getMaxOutputTokens() {
        return this.maxOutputTokens;
    }

    public String getModel() {
        return this.model;
    }

    public List<ResponsesItem> getOutput() {
        return this.output;
    }

    public boolean isParallelToolCalls() {
        return this.parallelToolCalls;
    }

    public String getPreviousResponseId() {
        return this.previousResponseId;
    }

    public ResponsesReasoningConfiguration getReasoning() {
        return this.reasoning;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public ResponseTextOptions getText() {
        return this.text;
    }

    public BinaryData getToolChoice() {
        return this.toolChoice;
    }

    public List<ResponsesTool> getTools() {
        return this.tools;
    }

    public double getTopP() {
        return this.topP;
    }

    public ResponseTruncation getTruncation() {
        return this.truncation;
    }

    public ResponsesResponseUsage getUsage() {
        return this.usage;
    }

    public String getUser() {
        return this.user;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeLongField("created_at", this.createdAt);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        jsonWriter.writeJsonField("incomplete_details", (JsonSerializable)this.incompleteDetails);
        jsonWriter.writeStringField("instructions", this.instructions);
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeArrayField("output", this.output, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("parallel_tool_calls", this.parallelToolCalls);
        jsonWriter.writeStringField("previous_response_id", this.previousResponseId);
        jsonWriter.writeDoubleField("temperature", this.temperature);
        jsonWriter.writeFieldName("tool_choice");
        this.toolChoice.writeTo(jsonWriter);
        jsonWriter.writeArrayField("tools", this.tools, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeDoubleField("top_p", this.topP);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeNumberField("max_output_tokens", (Number)this.maxOutputTokens);
        jsonWriter.writeJsonField("reasoning", (JsonSerializable)this.reasoning);
        jsonWriter.writeJsonField("text", (JsonSerializable)this.text);
        jsonWriter.writeStringField("truncation", this.truncation == null ? null : this.truncation.toString());
        jsonWriter.writeJsonField("usage", (JsonSerializable)this.usage);
        jsonWriter.writeStringField("user", this.user);
        return jsonWriter.writeEndObject();
    }

    public static ResponsesResponse fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesResponse)jsonReader.readObject(reader -> {
            String id = null;
            OffsetDateTime createdAt = null;
            ResponsesError error = null;
            ResponsesResponseIncompleteDetails incompleteDetails = null;
            String instructions = null;
            String model = null;
            List output = null;
            boolean parallelToolCalls = false;
            String previousResponseId = null;
            double temperature = 0.0;
            BinaryData toolChoice = null;
            List tools = null;
            double topP = 0.0;
            Map metadata = null;
            ResponsesResponseStatus status = null;
            Integer maxOutputTokens = null;
            ResponsesReasoningConfiguration reasoning = null;
            ResponseTextOptions text = null;
            ResponseTruncation truncation = null;
            ResponsesResponseUsage usage = null;
            String user = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("created_at".equals(fieldName)) {
                    createdAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = ResponsesError.fromJson(reader);
                    continue;
                }
                if ("incomplete_details".equals(fieldName)) {
                    incompleteDetails = ResponsesResponseIncompleteDetails.fromJson(reader);
                    continue;
                }
                if ("instructions".equals(fieldName)) {
                    instructions = reader.getString();
                    continue;
                }
                if ("model".equals(fieldName)) {
                    model = reader.getString();
                    continue;
                }
                if ("output".equals(fieldName)) {
                    output = reader.readArray(reader1 -> ResponsesItem.fromJson(reader1));
                    continue;
                }
                if ("parallel_tool_calls".equals(fieldName)) {
                    parallelToolCalls = reader.getBoolean();
                    continue;
                }
                if ("previous_response_id".equals(fieldName)) {
                    previousResponseId = reader.getString();
                    continue;
                }
                if ("temperature".equals(fieldName)) {
                    temperature = reader.getDouble();
                    continue;
                }
                if ("tool_choice".equals(fieldName)) {
                    toolChoice = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("tools".equals(fieldName)) {
                    tools = reader.readArray(reader1 -> ResponsesTool.fromJson(reader1));
                    continue;
                }
                if ("top_p".equals(fieldName)) {
                    topP = reader.getDouble();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = ResponsesResponseStatus.fromString(reader.getString());
                    continue;
                }
                if ("max_output_tokens".equals(fieldName)) {
                    maxOutputTokens = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("reasoning".equals(fieldName)) {
                    reasoning = ResponsesReasoningConfiguration.fromJson(reader);
                    continue;
                }
                if ("text".equals(fieldName)) {
                    text = ResponseTextOptions.fromJson(reader);
                    continue;
                }
                if ("truncation".equals(fieldName)) {
                    truncation = ResponseTruncation.fromString(reader.getString());
                    continue;
                }
                if ("usage".equals(fieldName)) {
                    usage = ResponsesResponseUsage.fromJson(reader);
                    continue;
                }
                if ("user".equals(fieldName)) {
                    user = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesResponse deserializedResponsesResponse = new ResponsesResponse(id, createdAt, error, incompleteDetails, instructions, model, output, parallelToolCalls, previousResponseId, temperature, toolChoice, tools, topP, metadata);
            deserializedResponsesResponse.status = status;
            deserializedResponsesResponse.maxOutputTokens = maxOutputTokens;
            deserializedResponsesResponse.reasoning = reasoning;
            deserializedResponsesResponse.text = text;
            deserializedResponsesResponse.truncation = truncation;
            deserializedResponsesResponse.usage = usage;
            deserializedResponsesResponse.user = user;
            return deserializedResponsesResponse;
        });
    }

    private ResponsesResponse(String id, OffsetDateTime createdAt, ResponsesError error, ResponsesResponseIncompleteDetails incompleteDetails, String instructions, String model, List<ResponsesItem> output, boolean parallelToolCalls, String previousResponseId, double temperature, BinaryData toolChoice, List<ResponsesTool> tools, double topP, Map<String, String> metadata) {
        this.id = id;
        this.createdAt = createdAt == null ? 0L : createdAt.toEpochSecond();
        this.error = error;
        this.incompleteDetails = incompleteDetails;
        this.instructions = instructions;
        this.model = model;
        this.output = output;
        this.parallelToolCalls = parallelToolCalls;
        this.previousResponseId = previousResponseId;
        this.temperature = temperature;
        this.toolChoice = toolChoice;
        this.tools = tools;
        this.topP = topP;
        this.metadata = metadata;
    }
}

