/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.models;

import com.azure.ai.textanalytics.implementation.ExtractiveSummaryResultPropertiesHelper;
import com.azure.ai.textanalytics.models.ExtractiveSummarySentence;
import com.azure.ai.textanalytics.models.TextAnalyticsError;
import com.azure.ai.textanalytics.models.TextAnalyticsResult;
import com.azure.ai.textanalytics.models.TextAnalyticsWarning;
import com.azure.ai.textanalytics.models.TextDocumentStatistics;
import com.azure.core.util.IterableStream;

public final class ExtractiveSummaryResult
extends TextAnalyticsResult {
    private IterableStream<ExtractiveSummarySentence> sentences;
    private IterableStream<TextAnalyticsWarning> warnings;

    public ExtractiveSummaryResult(String id, TextDocumentStatistics textDocumentStatistics, TextAnalyticsError error) {
        super(id, textDocumentStatistics, error);
    }

    public IterableStream<ExtractiveSummarySentence> getSentences() {
        this.throwExceptionIfError();
        return this.sentences;
    }

    public IterableStream<TextAnalyticsWarning> getWarnings() {
        return this.warnings;
    }

    private void setSentences(IterableStream<ExtractiveSummarySentence> sentences) {
        this.sentences = sentences;
    }

    private void setWarnings(IterableStream<TextAnalyticsWarning> warnings) {
        this.warnings = warnings;
    }

    static {
        ExtractiveSummaryResultPropertiesHelper.setAccessor(new ExtractiveSummaryResultPropertiesHelper.ExtractiveSummaryResultAccessor(){

            @Override
            public void setSentences(ExtractiveSummaryResult documentResult, IterableStream<ExtractiveSummarySentence> sentences) {
                documentResult.setSentences((IterableStream<ExtractiveSummarySentence>)sentences);
            }

            @Override
            public void setWarnings(ExtractiveSummaryResult documentResult, IterableStream<TextAnalyticsWarning> warnings) {
                documentResult.setWarnings((IterableStream<TextAnalyticsWarning>)warnings);
            }
        });
    }
}

