/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation.handler;

import com.azure.core.amqp.exception.AmqpErrorContext;
import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.amqp.exception.SessionErrorContext;
import com.azure.core.amqp.implementation.AmqpLoggingUtils;
import com.azure.core.amqp.implementation.AmqpMetricsProvider;
import com.azure.core.amqp.implementation.ExceptionUtil;
import com.azure.core.amqp.implementation.ReactorDispatcher;
import com.azure.core.amqp.implementation.handler.Handler;
import com.azure.core.util.logging.LoggingEventBuilder;
import java.io.IOException;
import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.RejectedExecutionException;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Session;

public class SessionHandler
extends Handler {
    private final String sessionName;
    private final Duration openTimeout;
    private final ReactorDispatcher reactorDispatcher;
    private final AmqpMetricsProvider metricsProvider;

    public SessionHandler(String connectionId, String hostname, String sessionName, ReactorDispatcher reactorDispatcher, Duration openTimeout, AmqpMetricsProvider metricProvider) {
        super(connectionId, hostname);
        this.sessionName = sessionName;
        this.openTimeout = openTimeout;
        this.reactorDispatcher = reactorDispatcher;
        this.metricsProvider = metricProvider;
    }

    public AmqpErrorContext getErrorContext() {
        return new SessionErrorContext(this.getHostname(), this.sessionName);
    }

    public void onSessionLocalOpen(Event e) {
        AmqpLoggingUtils.addErrorCondition(this.logger.atVerbose(), e.getSession().getCondition()).addKeyValue("sessionName", this.sessionName).log("onSessionLocalOpen");
        Session session = e.getSession();
        try {
            this.reactorDispatcher.invoke(this::onSessionTimeout, this.openTimeout);
        }
        catch (IOException | RejectedExecutionException ioException) {
            this.logger.atInfo().addKeyValue("sessionName", this.sessionName).addKeyValue("reactorDispatcherError", ioException.getMessage()).log("onSessionLocalOpen");
            session.close();
            String message = String.format(Locale.US, "onSessionLocalOpen connectionId[%s], entityName[%s], underlying IO of reactorDispatcher faulted with error: %s", this.getConnectionId(), this.sessionName, ioException.getMessage());
            AmqpException exception = new AmqpException(false, message, (Throwable)ioException, this.getErrorContext());
            this.onError((Throwable)((Object)exception));
        }
    }

    public void onSessionRemoteOpen(Event e) {
        LoggingEventBuilder logBuilder;
        Session session = e.getSession();
        if (session.getLocalState() == EndpointState.UNINITIALIZED) {
            logBuilder = this.logger.atWarning();
            session.open();
        } else {
            logBuilder = this.logger.atInfo();
        }
        logBuilder.addKeyValue("sessionName", this.sessionName).addKeyValue("sessionIncCapacity", (long)session.getIncomingCapacity()).addKeyValue("sessionOutgoingWindow", session.getOutgoingWindow()).log("onSessionRemoteOpen");
        this.onNext(EndpointState.ACTIVE);
    }

    public void onSessionLocalClose(Event e) {
        ErrorCondition condition = e != null && e.getSession() != null ? e.getSession().getCondition() : null;
        AmqpLoggingUtils.addErrorCondition(this.logger.atVerbose(), condition).addKeyValue("sessionName", this.sessionName).log("onSessionLocalClose");
    }

    public void onSessionRemoteClose(Event e) {
        Session session = e.getSession();
        ErrorCondition condition = session != null ? session.getRemoteCondition() : null;
        AmqpLoggingUtils.addErrorCondition(this.logger.atInfo(), condition).addKeyValue("sessionName", this.sessionName).log("onSessionRemoteClose");
        if (session != null && session.getLocalState() != EndpointState.CLOSED) {
            AmqpLoggingUtils.addErrorCondition(this.logger.atInfo(), condition).addKeyValue("sessionName", this.sessionName).log("onSessionRemoteClose closing a local session.");
            session.setCondition(session.getRemoteCondition());
            session.close();
        }
        if (condition == null || condition.getCondition() == null) {
            this.onNext(EndpointState.CLOSED);
        } else {
            String id = this.getConnectionId();
            AmqpErrorContext context = this.getErrorContext();
            Exception exception = ExceptionUtil.toException(condition.getCondition().toString(), String.format(Locale.US, "onSessionRemoteClose connectionId[%s], entityName[%s] condition[%s]", id, this.sessionName, condition), context);
            this.metricsProvider.recordHandlerError(AmqpMetricsProvider.ErrorSource.SESSION, condition);
            this.onError(exception);
        }
    }

    public void onSessionFinal(Event e) {
        Session session = e.getSession();
        ErrorCondition condition = session != null ? session.getCondition() : null;
        AmqpLoggingUtils.addErrorCondition(this.logger.atInfo(), condition).addKeyValue("sessionName", this.sessionName).log("onSessionFinal.");
        this.close();
    }

    private void onSessionTimeout() {
    }
}

