/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.jdk.httpclient.implementation;

import com.azure.core.http.HttpHeaders;
import com.azure.core.util.CoreUtils;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public final class JdkHttpUtils {
    private static final Timer TIMER = new Timer("azure-jdk-httpclient-network-timeout-tracker", true);

    public static HttpHeaders fromJdkHttpHeaders(java.net.http.HttpHeaders headers) {
        HttpHeaders httpHeaders = new HttpHeaders((int)((float)headers.map().size() / 0.75f));
        for (Map.Entry<String, List<String>> kvp : headers.map().entrySet()) {
            if (CoreUtils.isNullOrEmpty((Collection)kvp.getValue())) continue;
            httpHeaders.set(kvp.getKey(), kvp.getValue());
        }
        return httpHeaders;
    }

    public static int getSizeOfBuffers(List<ByteBuffer> buffers) {
        long size = 0L;
        for (ByteBuffer buffer : buffers) {
            if ((size += (long)buffer.remaining()) <= Integer.MAX_VALUE) continue;
            throw new IllegalStateException("The size of the buffers is greater than Integer.MAX_VALUE.");
        }
        return (int)size;
    }

    public static void scheduleTimeoutTask(TimerTask task, long timeoutMillis) {
        TIMER.schedule(task, timeoutMillis);
    }

    private JdkHttpUtils() {
    }
}

