/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp.implementation;

import com.azure.core.http.HttpRequest;
import com.azure.core.http.okhttp.implementation.OkHttpAsyncResponseBase;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import okhttp3.Response;
import okhttp3.ResponseBody;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class OkHttpAsyncResponse
extends OkHttpAsyncResponseBase {
    private static final int BYTE_BUFFER_CHUNK_SIZE = 8192;
    private final ResponseBody responseBody;

    public OkHttpAsyncResponse(Response response, HttpRequest request, boolean eagerlyConvertHeaders) {
        super(response, request, eagerlyConvertHeaders);
        this.responseBody = response.body();
    }

    public BinaryData getBodyAsBinaryData() {
        return BinaryData.fromStream((InputStream)this.responseBody.byteStream());
    }

    public Flux<ByteBuffer> getBody() {
        if (this.responseBody == null) {
            return Flux.empty();
        }
        return Flux.using(() -> ((ResponseBody)this.responseBody).byteStream(), bodyStream -> FluxUtil.toFluxByteBuffer((InputStream)bodyStream, (int)8192), bodyStream -> this.close(), (boolean)false);
    }

    public Mono<byte[]> getBodyAsByteArray() {
        return Mono.fromCallable(() -> {
            if (this.responseBody == null) {
                return null;
            }
            byte[] content = this.responseBody.bytes();
            if (content.length == 0) {
                return null;
            }
            return content;
        });
    }

    public Mono<InputStream> getBodyAsInputStream() {
        if (this.responseBody == null) {
            return Mono.empty();
        }
        return Mono.using(() -> ((ResponseBody)this.responseBody).byteStream(), Mono::just, ignored -> this.close(), (boolean)false);
    }

    public void writeBodyTo(WritableByteChannel channel) throws IOException {
        if (this.responseBody != null) {
            try {
                IOUtils.transfer((ReadableByteChannel)this.responseBody.source(), (WritableByteChannel)channel, (Long)this.responseBody.contentLength());
            }
            finally {
                this.close();
            }
        }
    }

    public Mono<Void> writeBodyToAsync(AsynchronousByteChannel channel) {
        if (this.responseBody != null) {
            return Mono.using(() -> this, ignored -> IOUtils.transferAsync((ReadableByteChannel)this.responseBody.source(), (AsynchronousByteChannel)channel, (Long)this.responseBody.contentLength()), OkHttpAsyncResponse::close);
        }
        return Mono.empty();
    }

    public void close() {
        if (this.responseBody != null) {
            this.responseBody.close();
        }
    }
}

