/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.metrics.opentelemetry;

import com.azure.core.metrics.opentelemetry.OpenTelemetryUtils;
import com.azure.core.util.TelemetryAttributes;
import com.azure.core.util.metrics.LongGauge;
import io.opentelemetry.api.metrics.LongGaugeBuilder;
import java.util.function.Supplier;

class OpenTelemetryLongGauge
implements LongGauge {
    private static final AutoCloseable NOOP_CLOSEABLE = () -> {};
    static final LongGauge NOOP = new LongGauge(){

        public AutoCloseable registerCallback(Supplier<Long> valueSupplier, TelemetryAttributes attributes) {
            return NOOP_CLOSEABLE;
        }

        public boolean isEnabled() {
            return false;
        }
    };
    private final LongGaugeBuilder gaugeBuilder;

    OpenTelemetryLongGauge(LongGaugeBuilder gaugeBuilder) {
        this.gaugeBuilder = gaugeBuilder;
    }

    public AutoCloseable registerCallback(Supplier<Long> valueSupplier, TelemetryAttributes attributes) {
        return this.gaugeBuilder.buildWithCallback(measurement -> measurement.record(((Long)valueSupplier.get()).longValue(), OpenTelemetryUtils.getAttributes(attributes)));
    }

    public boolean isEnabled() {
        return true;
    }
}

