/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.metrics.opentelemetry;

import com.azure.core.metrics.opentelemetry.OpenTelemetryAttributes;
import com.azure.core.metrics.opentelemetry.OpenTelemetryDoubleHistogram;
import com.azure.core.metrics.opentelemetry.OpenTelemetryLongCounter;
import com.azure.core.metrics.opentelemetry.OpenTelemetryLongGauge;
import com.azure.core.metrics.opentelemetry.OpenTelemetryLongUpDownCounter;
import com.azure.core.metrics.opentelemetry.OpenTelemetryMetricsOptions;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.MetricsOptions;
import com.azure.core.util.TelemetryAttributes;
import com.azure.core.util.metrics.DoubleHistogram;
import com.azure.core.util.metrics.LongCounter;
import com.azure.core.util.metrics.LongGauge;
import com.azure.core.util.metrics.Meter;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.api.metrics.LongCounterBuilder;
import io.opentelemetry.api.metrics.LongGaugeBuilder;
import io.opentelemetry.api.metrics.LongUpDownCounterBuilder;
import io.opentelemetry.api.metrics.MeterProvider;
import java.util.Map;
import java.util.Objects;

class OpenTelemetryMeter
implements Meter {
    private final io.opentelemetry.api.metrics.Meter meter;
    private final boolean isEnabled;
    private static final LongCounter NOOP_COUNTER = new LongCounter(){

        public void add(long value, TelemetryAttributes attributes, Context context) {
        }

        public boolean isEnabled() {
            return false;
        }
    };

    OpenTelemetryMeter(String libraryName, String libraryVersion, MetricsOptions options) {
        MeterProvider otelProvider = GlobalOpenTelemetry.getMeterProvider();
        if (options != null && options.isEnabled() && options instanceof OpenTelemetryMetricsOptions) {
            OpenTelemetryMetricsOptions otelOptions = (OpenTelemetryMetricsOptions)options;
            otelProvider = otelOptions.getOpenTelemetryProvider();
        }
        this.isEnabled = (options == null || options.isEnabled()) && otelProvider != MeterProvider.noop();
        this.meter = otelProvider.meterBuilder(libraryName).setInstrumentationVersion(libraryVersion).build();
    }

    public DoubleHistogram createDoubleHistogram(String name, String description, String unit) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        Objects.requireNonNull(description, "'description' cannot be null.");
        if (!this.isEnabled) {
            return OpenTelemetryDoubleHistogram.NOOP;
        }
        DoubleHistogramBuilder otelMetricBuilder = this.meter.histogramBuilder(name).setDescription(description);
        if (!CoreUtils.isNullOrEmpty((CharSequence)unit)) {
            otelMetricBuilder.setUnit(unit);
        }
        return new OpenTelemetryDoubleHistogram(otelMetricBuilder.build());
    }

    public LongCounter createLongCounter(String name, String description, String unit) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        Objects.requireNonNull(description, "'description' cannot be null.");
        if (!this.isEnabled) {
            return NOOP_COUNTER;
        }
        LongCounterBuilder otelMetricBuilder = this.meter.counterBuilder(name).setDescription(description);
        if (!CoreUtils.isNullOrEmpty((CharSequence)unit)) {
            otelMetricBuilder.setUnit(unit);
        }
        return new OpenTelemetryLongCounter(otelMetricBuilder.build());
    }

    public LongCounter createLongUpDownCounter(String name, String description, String unit) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        Objects.requireNonNull(description, "'description' cannot be null.");
        if (!this.isEnabled) {
            return NOOP_COUNTER;
        }
        LongUpDownCounterBuilder otelMetricBuilder = this.meter.upDownCounterBuilder(name).setDescription(description);
        if (!CoreUtils.isNullOrEmpty((CharSequence)unit)) {
            otelMetricBuilder.setUnit(unit);
        }
        return new OpenTelemetryLongUpDownCounter(otelMetricBuilder.build());
    }

    public LongGauge createLongGauge(String name, String description, String unit) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        Objects.requireNonNull(description, "'description' cannot be null.");
        if (!this.isEnabled) {
            return OpenTelemetryLongGauge.NOOP;
        }
        LongGaugeBuilder otelMetricBuilder = this.meter.gaugeBuilder(name).setDescription(description).ofLongs();
        if (!CoreUtils.isNullOrEmpty((CharSequence)unit)) {
            otelMetricBuilder.setUnit(unit);
        }
        return new OpenTelemetryLongGauge(otelMetricBuilder);
    }

    public TelemetryAttributes createAttributes(Map<String, Object> attributeMap) {
        return new OpenTelemetryAttributes(attributeMap);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void close() {
    }
}

