/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.json.jackson.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriteContext;
import com.azure.json.JsonWriter;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Objects;

public final class JacksonJsonWriter
extends JsonWriter {
    private static final ClientLogger LOGGER = new ClientLogger(JacksonJsonWriter.class);
    private final JsonGenerator generator;
    private JsonWriteContext context = JsonWriteContext.ROOT;

    JacksonJsonWriter(JsonGenerator generator) {
        this.generator = Objects.requireNonNull(generator, "Cannot create a Jackson-based instance of com.azure.json.JsonWriter with a null Jackson JsonGenerator.");
    }

    public JsonWriteContext getWriteContext() {
        return this.context;
    }

    public void close() throws IOException {
        if (this.context != JsonWriteContext.COMPLETED) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Writing of the JSON object must be completed before the writer can be closed. Current writing state is '" + this.context.getWriteState() + "'."));
        }
        this.generator.flush();
        this.generator.close();
    }

    public JsonWriter flush() throws IOException {
        this.generator.flush();
        return this;
    }

    public JsonWriter writeStartObject() throws IOException {
        this.context.validateToken(JsonToken.START_OBJECT);
        this.generator.writeStartObject();
        this.context = this.context.updateContext(JsonToken.START_OBJECT);
        return this;
    }

    public JsonWriter writeEndObject() throws IOException {
        this.context.validateToken(JsonToken.END_OBJECT);
        this.generator.writeEndObject();
        this.context = this.context.updateContext(JsonToken.END_OBJECT);
        return this;
    }

    public JsonWriter writeStartArray() throws IOException {
        this.context.validateToken(JsonToken.START_ARRAY);
        this.generator.writeStartArray();
        this.context = this.context.updateContext(JsonToken.START_ARRAY);
        return this;
    }

    public JsonWriter writeEndArray() throws IOException {
        this.context.validateToken(JsonToken.END_ARRAY);
        this.generator.writeEndArray();
        this.context = this.context.updateContext(JsonToken.END_ARRAY);
        return this;
    }

    public JsonWriter writeFieldName(String fieldName) throws IOException {
        Objects.requireNonNull(fieldName, "'fieldName' cannot be null.");
        this.context.validateToken(JsonToken.FIELD_NAME);
        this.generator.writeFieldName(fieldName);
        this.context = this.context.updateContext(JsonToken.FIELD_NAME);
        return this;
    }

    public JsonWriter writeBinary(byte[] value) throws IOException {
        this.context.validateToken(JsonToken.STRING);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeBinary(value);
        }
        this.context = this.context.updateContext(JsonToken.STRING);
        return this;
    }

    public JsonWriter writeBoolean(boolean value) throws IOException {
        this.context.validateToken(JsonToken.BOOLEAN);
        this.generator.writeBoolean(value);
        this.context = this.context.updateContext(JsonToken.BOOLEAN);
        return this;
    }

    public JsonWriter writeDouble(double value) throws IOException {
        this.context.validateToken(JsonToken.NUMBER);
        this.generator.writeNumber(value);
        this.context = this.context.updateContext(JsonToken.NUMBER);
        return this;
    }

    public JsonWriter writeFloat(float value) throws IOException {
        this.context.validateToken(JsonToken.NUMBER);
        this.generator.writeNumber(value);
        this.context = this.context.updateContext(JsonToken.NUMBER);
        return this;
    }

    public JsonWriter writeInt(int value) throws IOException {
        this.context.validateToken(JsonToken.NUMBER);
        this.generator.writeNumber(value);
        this.context = this.context.updateContext(JsonToken.NUMBER);
        return this;
    }

    public JsonWriter writeLong(long value) throws IOException {
        this.context.validateToken(JsonToken.NUMBER);
        this.generator.writeNumber(value);
        this.context = this.context.updateContext(JsonToken.NUMBER);
        return this;
    }

    public JsonWriter writeNull() throws IOException {
        this.context.validateToken(JsonToken.NULL);
        this.generator.writeNull();
        this.context = this.context.updateContext(JsonToken.NULL);
        return this;
    }

    public JsonWriter writeString(String value) throws IOException {
        this.context.validateToken(JsonToken.STRING);
        this.generator.writeString(value);
        this.context = this.context.updateContext(JsonToken.STRING);
        return this;
    }

    public JsonWriter writeRawValue(String value) throws IOException {
        Objects.requireNonNull(value, "'value' cannot be null.");
        this.context.validateToken(JsonToken.STRING);
        this.generator.writeRawValue(value);
        this.context = this.context.updateContext(JsonToken.STRING);
        return this;
    }
}

