/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.policy;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.test.models.RecordFilePayload;
import com.azure.core.test.models.TestProxyRecordingOptions;
import com.azure.core.test.models.TestProxySanitizer;
import com.azure.core.test.utils.HttpURLConnectionHttpClient;
import com.azure.core.test.utils.TestProxyUtils;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import reactor.core.publisher.Mono;

public class TestProxyRecordPolicy
implements HttpPipelinePolicy {
    private static final SerializerAdapter SERIALIZER = new JacksonAdapter();
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final HttpHeaderName X_RECORDING_ID = HttpHeaderName.fromString((String)"x-recording-id");
    private final HttpClient client;
    private final URL proxyUrl;
    private final boolean skipRecordingRequestBody;
    private String xRecordingId;
    private final List<TestProxySanitizer> sanitizers = new ArrayList<TestProxySanitizer>();
    private static final List<TestProxySanitizer> DEFAULT_SANITIZERS = TestProxyUtils.loadSanitizers();
    public static final String RECORD_MODE = "record";

    public TestProxyRecordPolicy(HttpClient httpClient, boolean skipRecordingRequestBody) {
        this.client = httpClient == null ? new HttpURLConnectionHttpClient() : httpClient;
        this.skipRecordingRequestBody = skipRecordingRequestBody;
        this.proxyUrl = TestProxyUtils.getProxyUrl();
        this.sanitizers.addAll(DEFAULT_SANITIZERS);
    }

    public void startRecording(File recordFile, Path testClassPath) {
        try {
            String assetJsonPath = TestProxyUtils.getAssetJsonFile(recordFile, testClassPath);
            HttpRequest request = new HttpRequest(HttpMethod.POST, this.proxyUrl + "/record/start").setBody(SERIALIZER.serialize((Object)new RecordFilePayload(recordFile.toString(), assetJsonPath), SerializerEncoding.JSON)).setHeader(HttpHeaderName.CONTENT_TYPE, "application/json");
            try (HttpResponse response = this.client.sendSync(request, Context.NONE);){
                TestProxyUtils.checkForTestProxyErrors(response);
                if (response.getStatusCode() != 200) {
                    throw new RuntimeException(response.getBodyAsBinaryData().toString());
                }
                this.xRecordingId = response.getHeaderValue(X_RECORDING_ID);
            }
            this.addProxySanitization(this.sanitizers);
            this.setDefaultRecordingOptions();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void setDefaultRecordingOptions() {
        HttpRequest request = new HttpRequest(HttpMethod.POST, this.proxyUrl + "/Admin/SetRecordingOptions").setBody("{\"HandleRedirects\": false}").setHeader(HttpHeaderName.CONTENT_TYPE, "application/json");
        this.client.sendSync(request, Context.NONE).close();
    }

    public void stopRecording(Queue<String> variables) {
        HttpRequest request = new HttpRequest(HttpMethod.POST, this.proxyUrl + "/record/stop").setHeader(HttpHeaderName.CONTENT_TYPE, "application/json").setHeader(X_RECORDING_ID, this.xRecordingId).setBody(this.serializeVariables(variables));
        try (HttpResponse response = this.client.sendSync(request, Context.NONE);){
            TestProxyUtils.checkForTestProxyErrors(response);
            if (response.getStatusCode() != 200) {
                throw new RuntimeException(response.getBodyAsBinaryData().toString());
            }
        }
    }

    private String serializeVariables(Queue<String> variables) {
        if (variables.isEmpty()) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder().append('{');
        int count = 0;
        for (String variable : variables) {
            if (count > 0) {
                builder.append(',');
            }
            builder.append('\"').append(count).append("\":\"");
            ++count;
            if (variable == null) {
                builder.append("null");
                continue;
            }
            builder.append(variable).append('\"');
        }
        return builder.append('}').toString();
    }

    private void beforeSendingRequest(HttpPipelineCallContext context) {
        TestProxyUtils.changeHeaders(context.getHttpRequest(), this.proxyUrl, this.xRecordingId, RECORD_MODE, this.skipRecordingRequestBody);
    }

    private HttpResponse afterReceivedResponse(HttpResponse response) {
        TestProxyUtils.checkForTestProxyErrors(response);
        return TestProxyUtils.resetTestProxyData(response);
    }

    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        this.beforeSendingRequest(context);
        HttpResponse response = next.processSync();
        return this.afterReceivedResponse(response);
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        return Mono.fromCallable(() -> {
            this.beforeSendingRequest(context);
            return next;
        }).flatMap(ignored -> next.process()).map(this::afterReceivedResponse);
    }

    public void addProxySanitization(List<TestProxySanitizer> sanitizers) {
        if (this.isRecording()) {
            HttpRequest request = TestProxyUtils.createAddSanitizersRequest(sanitizers, this.proxyUrl).setHeader(X_RECORDING_ID, this.xRecordingId);
            this.client.sendSync(request, Context.NONE).close();
        } else {
            this.sanitizers.addAll(sanitizers);
        }
    }

    private boolean isRecording() {
        return this.xRecordingId != null;
    }

    public void setRecordingOptions(TestProxyRecordingOptions testProxyRecordingOptions) {
        try {
            HttpRequest request = new HttpRequest(HttpMethod.POST, this.proxyUrl + "/admin/setrecordingoptions").setBody(MAPPER.writeValueAsString((Object)testProxyRecordingOptions)).setHeader(HttpHeaderName.CONTENT_TYPE, "application/json");
            this.client.sendSync(request, Context.NONE).close();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to process JSON input", ex);
        }
    }
}

