/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.annotation.ServiceClient;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosClientBuilder;
import com.azure.cosmos.CosmosDatabase;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.GlobalThroughputControlConfigBuilder;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.models.CosmosContainerIdentity;
import com.azure.cosmos.models.CosmosDatabaseProperties;
import com.azure.cosmos.models.CosmosDatabaseRequestOptions;
import com.azure.cosmos.models.CosmosDatabaseResponse;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.models.ThroughputProperties;
import com.azure.cosmos.util.CosmosPagedFlux;
import com.azure.cosmos.util.CosmosPagedIterable;
import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

@ServiceClient(builder=CosmosClientBuilder.class)
public final class CosmosClient
implements Closeable {
    private final CosmosAsyncClient asyncClientWrapper;

    CosmosClient(CosmosClientBuilder builder) {
        this.asyncClientWrapper = builder.buildAsyncClient(false);
    }

    CosmosDatabaseResponse createDatabaseIfNotExists(CosmosDatabaseProperties databaseProperties) {
        return this.blockDatabaseResponse(this.asyncClientWrapper.createDatabaseIfNotExists(databaseProperties));
    }

    public CosmosDatabaseResponse createDatabaseIfNotExists(String id, ThroughputProperties throughputProperties) {
        return this.blockDatabaseResponse(this.asyncClientWrapper.createDatabaseIfNotExists(id, throughputProperties));
    }

    public CosmosDatabaseResponse createDatabaseIfNotExists(String id) {
        return this.blockDatabaseResponse(this.asyncClientWrapper.createDatabaseIfNotExists(id));
    }

    public CosmosDatabaseResponse createDatabase(CosmosDatabaseProperties databaseProperties, CosmosDatabaseRequestOptions options) {
        return this.blockDatabaseResponse(this.asyncClientWrapper.createDatabase(databaseProperties, options));
    }

    public CosmosDatabaseResponse createDatabase(CosmosDatabaseProperties databaseProperties) {
        return this.blockDatabaseResponse(this.asyncClientWrapper.createDatabase(databaseProperties));
    }

    public CosmosDatabaseResponse createDatabase(String id) {
        return this.blockDatabaseResponse(this.asyncClientWrapper.createDatabase(id));
    }

    public CosmosDatabaseResponse createDatabase(CosmosDatabaseProperties databaseProperties, ThroughputProperties throughputProperties, CosmosDatabaseRequestOptions options) {
        return this.blockDatabaseResponse(this.asyncClientWrapper.createDatabase(databaseProperties, throughputProperties, options));
    }

    public CosmosDatabaseResponse createDatabase(CosmosDatabaseProperties databaseProperties, ThroughputProperties throughputProperties) {
        return this.blockDatabaseResponse(this.asyncClientWrapper.createDatabase(databaseProperties, throughputProperties));
    }

    public CosmosDatabaseResponse createDatabase(String id, ThroughputProperties throughputProperties) {
        return this.blockDatabaseResponse(this.asyncClientWrapper.createDatabase(id, throughputProperties));
    }

    void openConnectionsAndInitCaches() {
        this.asyncClientWrapper.openConnectionsAndInitCaches();
    }

    void openConnectionsAndInitCaches(Duration aggressiveWarmupDuration) {
        this.asyncClientWrapper.openConnectionsAndInitCaches(aggressiveWarmupDuration);
    }

    void recordOpenConnectionsAndInitCachesCompleted(List<CosmosContainerIdentity> cosmosContainerIdentities) {
        this.asyncClientWrapper.recordOpenConnectionsAndInitCachesCompleted(cosmosContainerIdentities);
    }

    void recordOpenConnectionsAndInitCachesStarted(List<CosmosContainerIdentity> cosmosContainerIdentities) {
        this.asyncClientWrapper.recordOpenConnectionsAndInitCachesStarted(cosmosContainerIdentities);
    }

    CosmosDatabaseResponse blockDatabaseResponse(Mono<CosmosDatabaseResponse> databaseMono) {
        try {
            return (CosmosDatabaseResponse)databaseMono.block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosException) {
                throw (CosmosException)((Object)throwable);
            }
            throw Exceptions.propagate((Throwable)ex);
        }
    }

    CosmosPagedIterable<CosmosDatabaseProperties> readAllDatabases(CosmosQueryRequestOptions options) {
        return this.getCosmosPagedIterable(this.asyncClientWrapper.readAllDatabases(options));
    }

    public CosmosPagedIterable<CosmosDatabaseProperties> readAllDatabases() {
        return this.getCosmosPagedIterable(this.asyncClientWrapper.readAllDatabases());
    }

    public CosmosPagedIterable<CosmosDatabaseProperties> queryDatabases(String query, CosmosQueryRequestOptions options) {
        return this.getCosmosPagedIterable(this.asyncClientWrapper.queryDatabases(query, options));
    }

    public CosmosPagedIterable<CosmosDatabaseProperties> queryDatabases(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.getCosmosPagedIterable(this.asyncClientWrapper.queryDatabases(querySpec, options));
    }

    public CosmosDatabase getDatabase(String id) {
        return new CosmosDatabase(id, this, this.asyncClientWrapper.getDatabase(id));
    }

    CosmosAsyncClient asyncClient() {
        return this.asyncClientWrapper;
    }

    @Override
    public void close() {
        this.asyncClientWrapper.close();
    }

    private <T> CosmosPagedIterable<T> getCosmosPagedIterable(CosmosPagedFlux<T> cosmosPagedFlux) {
        return new CosmosPagedIterable<T>(cosmosPagedFlux);
    }

    public GlobalThroughputControlConfigBuilder createGlobalThroughputControlConfigBuilder(String databaseId, String containerId) {
        return new GlobalThroughputControlConfigBuilder(this.asyncClientWrapper, databaseId, containerId);
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosClientHelper.setCosmosClientAccessor(cosmosClient -> cosmosClient.asyncClient());
    }

    static {
        CosmosClient.initialize();
    }
}

