/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.throughputControl.config;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.GlobalThroughputControlConfig;
import com.azure.cosmos.ThroughputControlGroupConfig;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.throughputControl.config.GlobalThroughputControlGroup;
import com.azure.cosmos.implementation.throughputControl.config.LocalThroughputControlGroup;

public class ThroughputControlGroupFactory {
    public static LocalThroughputControlGroup createThroughputLocalControlGroup(ThroughputControlGroupConfig groupConfig, CosmosAsyncContainer targetContainer) {
        Preconditions.checkNotNull(groupConfig, "Throughput control group config can not be null");
        Preconditions.checkNotNull(targetContainer, "Throughput target container can not be null");
        return new LocalThroughputControlGroup(groupConfig.getGroupName(), targetContainer, groupConfig.getTargetThroughput(), groupConfig.getTargetThroughputThreshold(), groupConfig.getPriorityLevel(), groupConfig.isDefault(), groupConfig.continueOnInitError());
    }

    public static GlobalThroughputControlGroup createThroughputGlobalControlGroup(ThroughputControlGroupConfig groupConfig, GlobalThroughputControlConfig globalControlConfig, CosmosAsyncContainer targetContainer) {
        Preconditions.checkNotNull(groupConfig, "Throughput control group config can not be null");
        Preconditions.checkNotNull(globalControlConfig, "Throughput global control config can not be null");
        Preconditions.checkNotNull(targetContainer, "Throughput target container can not be null");
        return new GlobalThroughputControlGroup(groupConfig.getGroupName(), targetContainer, groupConfig.getTargetThroughput(), groupConfig.getTargetThroughputThreshold(), groupConfig.getPriorityLevel(), groupConfig.isDefault(), groupConfig.continueOnInitError(), BridgeInternal.getControlContainerFromThroughputGlobalControlConfig(globalControlConfig), globalControlConfig.getControlItemRenewInterval(), globalControlConfig.getControlItemExpireInterval());
    }
}

