/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosRegionSwitchHint;
import com.azure.cosmos.SessionRetryOptions;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.time.Duration;

public final class SessionRetryOptionsBuilder {
    private CosmosRegionSwitchHint regionSwitchHint;
    private Duration minInRegionRetryTime = Configs.getMinRetryTimeInLocalRegionWhenRemoteRegionPreferred();
    private int maxInRegionRetryCount = Configs.getMaxRetriesInLocalRegionWhenRemoteRegionPreferred();

    public SessionRetryOptionsBuilder regionSwitchHint(CosmosRegionSwitchHint regionSwitchHint) {
        this.regionSwitchHint = regionSwitchHint;
        return this;
    }

    public SessionRetryOptionsBuilder minTimeoutPerRegion(Duration minTimeoutPerRegion) {
        this.minInRegionRetryTime = minTimeoutPerRegion;
        return this;
    }

    public SessionRetryOptionsBuilder maxRetriesPerRegion(int maxRetriesPerRegion) {
        this.maxInRegionRetryCount = maxRetriesPerRegion;
        return this;
    }

    public SessionRetryOptions build() {
        Preconditions.checkNotNull(this.regionSwitchHint, "regionSwitch hint cannot be null");
        if (this.regionSwitchHint == CosmosRegionSwitchHint.REMOTE_REGION_PREFERRED) {
            Preconditions.checkArgument(this.minInRegionRetryTime != null, "Argument 'minInRegionRetryTimeForWriteOperations' must not be null when 'regionSwitchHint' is 'REMOTE_REGION_PREFERRED'.");
            Preconditions.checkArgument(this.minInRegionRetryTime.compareTo(Duration.ofMillis(100L)) >= 0, "Argument 'minInRegionRetryTime' must have at least a value of '" + Duration.ofMillis(100L) + "' when 'regionSwitchHint' is 'REMOTE_REGION_PREFERRED'.");
            Preconditions.checkArgument(this.maxInRegionRetryCount >= 1, "Argument 'maxInRegionRetryCount' must have at least a value of '1' when 'regionSwitchHint' is 'REMOTE_REGION_PREFERRED'.");
        }
        return new SessionRetryOptions(this.regionSwitchHint, this.minInRegionRetryTime, this.maxInRegionRetryCount);
    }
}

