/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.guava27.Strings;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class CosmosDaemonThreadFactory
implements ThreadFactory {
    private static final String NAME_TEMPLATE = "cosmos-daemon-%s[%s]";
    private final String namePrefix;
    private final AtomicInteger threadCount;

    public CosmosDaemonThreadFactory(String namePrefix) {
        Preconditions.checkNotNull(namePrefix, "Argument namePrefix must not be null.");
        this.namePrefix = namePrefix;
        this.threadCount = new AtomicInteger(0);
    }

    @Override
    public Thread newThread(Runnable r) {
        String name = Strings.lenientFormat(NAME_TEMPLATE, this.namePrefix, this.threadCount.incrementAndGet());
        Thread t = new Thread(r, name);
        t.setDaemon(true);
        return t;
    }
}

