/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.implementation.ApiType;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.GlobalEndpointManager;
import com.azure.cosmos.implementation.ISessionContainer;
import com.azure.cosmos.implementation.QueryCompatibilityMode;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.RxDocumentServiceResponse;
import com.azure.cosmos.implementation.RxGatewayStoreModel;
import com.azure.cosmos.implementation.UserAgentContainer;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequest;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestArgs;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.http.HttpClient;
import com.azure.cosmos.implementation.http.HttpHeaders;
import com.azure.cosmos.implementation.http.HttpRequest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpMethod;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ThinClientStoreModel
extends RxGatewayStoreModel {
    public ThinClientStoreModel(DiagnosticsClientContext clientContext, ISessionContainer sessionContainer, ConsistencyLevel defaultConsistencyLevel, UserAgentContainer userAgentContainer, GlobalEndpointManager globalEndpointManager, HttpClient httpClient) {
        super(clientContext, sessionContainer, defaultConsistencyLevel, QueryCompatibilityMode.Default, userAgentContainer, globalEndpointManager, httpClient, ApiType.SQL);
    }

    public ThinClientStoreModel(ThinClientStoreModel inner) {
        super(inner);
    }

    @Override
    public Mono<RxDocumentServiceResponse> processMessage(RxDocumentServiceRequest request) {
        return super.processMessage(request);
    }

    @Override
    protected Map<String, String> getDefaultHeaders(ApiType apiType, UserAgentContainer userAgentContainer, ConsistencyLevel clientDefaultConsistencyLevel) {
        Preconditions.checkNotNull(userAgentContainer, "Argument 'userAGentContainer' must not be null.");
        HashMap<String, String> defaultHeaders = new HashMap<String, String>();
        defaultHeaders.put("User-Agent", userAgentContainer.getUserAgent());
        return defaultHeaders;
    }

    @Override
    public HttpRequest wrapInHttpRequest(RxDocumentServiceRequest request, URI requestUri) throws Exception {
        request.setThinclientHeaders(request.getOperationType().name(), request.getResourceType().name());
        RntbdRequestArgs rntbdRequestArgs = new RntbdRequestArgs(request);
        HttpHeaders headers = this.getHttpHeaders();
        RntbdRequest rntbdRequest = RntbdRequest.from(rntbdRequestArgs);
        ByteBuf byteBuf = Unpooled.buffer();
        rntbdRequest.encode(byteBuf, true);
        return new HttpRequest(HttpMethod.POST, requestUri, requestUri.getPort(), headers, (Flux<byte[]>)Flux.just((Object)byteBuf.array()));
    }

    private HttpHeaders getHttpHeaders() {
        HttpHeaders httpHeaders = new HttpHeaders();
        Map<String, String> defaultHeaders = this.getDefaultHeaders();
        for (Map.Entry<String, String> header : defaultHeaders.entrySet()) {
            httpHeaders.set(header.getKey(), header.getValue());
        }
        return httpHeaders;
    }
}

