/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdContextRequest;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RntbdContextRequestEncoder
extends MessageToByteEncoder<RntbdContextRequest> {
    private static final Logger Logger = LoggerFactory.getLogger(RntbdContextRequestEncoder.class);

    RntbdContextRequestEncoder() {
    }

    public boolean acceptOutboundMessage(Object message) {
        return message.getClass() == RntbdContextRequest.class;
    }

    protected void encode(ChannelHandlerContext context, RntbdContextRequest message, ByteBuf out) throws IllegalStateException {
        out.markWriterIndex();
        try {
            message.encode(out);
        }
        catch (IllegalStateException error) {
            out.resetWriterIndex();
            throw error;
        }
        Logger.debug("{}: ENCODE COMPLETE: message={}", (Object)context.channel(), (Object)message);
    }
}

