/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.CosmosDiagnosticsContext;
import com.azure.cosmos.CosmosRequestContext;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.OverridableRequestOptions;
import com.azure.cosmos.models.CosmosRequestOptions;

public final class CosmosOperationDetails {
    private final OverridableRequestOptions requestOptions;
    private final CosmosDiagnosticsContext cosmosDiagnosticsContext;

    CosmosOperationDetails(OverridableRequestOptions requestOptions, CosmosDiagnosticsContext cosmosDiagnosticsContext) {
        this.requestOptions = requestOptions;
        this.cosmosDiagnosticsContext = cosmosDiagnosticsContext;
    }

    public void setRequestOptions(CosmosRequestOptions cosmosRequestOptions) {
        this.requestOptions.override(cosmosRequestOptions);
    }

    public CosmosRequestContext getRequestContext() {
        return ImplementationBridgeHelpers.CosmosRequestContextHelper.getCosmosRequestContextAccessor().create(this.requestOptions);
    }

    public CosmosDiagnosticsContext getDiagnosticsContext() {
        return this.cosmosDiagnosticsContext;
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosOperationDetailsHelper.setCosmosOperationDetailsAccessor(CosmosOperationDetails::new);
    }
}

