/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.CosmosVectorDataType;
import com.azure.cosmos.models.CosmosVectorDistanceFunction;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class CosmosVectorEmbedding {
    @JsonProperty(value="path")
    private String path;
    @JsonProperty(value="dataType")
    private String dataType;
    @JsonProperty(value="dimensions")
    private Integer dimensions;
    @JsonProperty(value="distanceFunction")
    private String distanceFunction;
    private JsonSerializable jsonSerializable = new JsonSerializable();

    public String getPath() {
        return this.path;
    }

    public CosmosVectorEmbedding setPath(String path) {
        if (StringUtils.isEmpty(path)) {
            throw new NullPointerException("embedding path is either null or empty");
        }
        if (path.charAt(0) != '/' || path.lastIndexOf(47) != 0) {
            throw new IllegalArgumentException("");
        }
        this.path = path;
        return this;
    }

    public CosmosVectorDataType getDataType() {
        return CosmosVectorDataType.fromString(this.dataType);
    }

    public CosmosVectorEmbedding setDataType(CosmosVectorDataType dataType) {
        Preconditions.checkNotNull(dataType, "cosmosVectorDataType cannot be null");
        this.dataType = dataType.toString();
        return this;
    }

    @JsonIgnore
    public Integer getEmbeddingDimensions() {
        return this.dimensions;
    }

    @JsonIgnore
    public CosmosVectorEmbedding setEmbeddingDimensions(Integer dimensions) {
        Preconditions.checkNotNull(dimensions, "dimensions cannot be null");
        if (dimensions < 1) {
            throw new IllegalArgumentException("Dimensions for the embedding has to be a int value greater than 0 for the vector embedding policy");
        }
        this.dimensions = dimensions;
        return this;
    }

    @Deprecated
    public Long getDimensions() {
        return (long)this.dimensions;
    }

    @Deprecated
    public CosmosVectorEmbedding setDimensions(Long dimensions) {
        Preconditions.checkNotNull(dimensions, "dimensions cannot be null");
        if (dimensions < 1L) {
            throw new IllegalArgumentException("Dimensions for the embedding has to be a long value greater than 0 for the vector embedding policy");
        }
        this.dimensions = Math.toIntExact(dimensions);
        return this;
    }

    public CosmosVectorDistanceFunction getDistanceFunction() {
        return CosmosVectorDistanceFunction.fromString(this.distanceFunction);
    }

    public CosmosVectorEmbedding setDistanceFunction(CosmosVectorDistanceFunction distanceFunction) {
        Preconditions.checkNotNull(distanceFunction, "cosmosVectorDistanceFunction cannot be null");
        this.distanceFunction = distanceFunction.toString();
        return this;
    }
}

