/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.query.IndexProperty;
import com.azure.cosmos.models.CosmosVectorIndexType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class CosmosVectorIndexSpec {
    private String type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="quantizationByteSize")
    private Integer quantizationSizeInBytes;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer indexingSearchListSize;
    private final JsonSerializable jsonSerializable = new JsonSerializable();

    public String getPath() {
        return this.jsonSerializable.getString("path");
    }

    public CosmosVectorIndexSpec setPath(String path) {
        this.jsonSerializable.set("path", path);
        return this;
    }

    public String getType() {
        if (this.type == null) {
            this.type = this.jsonSerializable.getString("type");
        }
        return this.type;
    }

    public CosmosVectorIndexSpec setType(String type) {
        Preconditions.checkNotNull(type, "cosmosVectorIndexType cannot be null");
        if (!CosmosVectorIndexType.isValidType(type)) {
            throw new IllegalArgumentException(String.format("%s is an invalid index type. Valid index types are 'flat', 'quantizedFlat' or 'diskANN'.", type));
        }
        this.type = type;
        this.jsonSerializable.set("type", this.type);
        return this;
    }

    public Integer getQuantizationSizeInBytes() {
        if (this.quantizationSizeInBytes == null) {
            this.quantizationSizeInBytes = this.jsonSerializable.getInt("quantizationByteSize");
        }
        return this.quantizationSizeInBytes;
    }

    public CosmosVectorIndexSpec setQuantizationSizeInBytes(Integer quantizationByteSize) {
        if (this.validateIndexType(IndexProperty.QUANTIZATION_SIZE_IN_BYTES).booleanValue() && quantizationByteSize != null) {
            this.quantizationSizeInBytes = quantizationByteSize;
            this.jsonSerializable.set("quantizationByteSize", this.quantizationSizeInBytes);
        } else {
            this.quantizationSizeInBytes = null;
        }
        return this;
    }

    public Integer getIndexingSearchListSize() {
        if (this.indexingSearchListSize == null) {
            this.indexingSearchListSize = this.jsonSerializable.getInt("indexingSearchListSize");
        }
        return this.indexingSearchListSize;
    }

    public CosmosVectorIndexSpec setIndexingSearchListSize(Integer indexingSearchListSize) {
        if (this.validateIndexType(IndexProperty.INDEXING_SEARCH_LIST_SIZE).booleanValue() && indexingSearchListSize != null) {
            this.indexingSearchListSize = indexingSearchListSize;
            this.jsonSerializable.set("indexingSearchListSize", this.indexingSearchListSize);
        } else {
            this.indexingSearchListSize = null;
        }
        return this;
    }

    void populatePropertyBag() {
        this.jsonSerializable.populatePropertyBag();
    }

    JsonSerializable getJsonSerializable() {
        return this.jsonSerializable;
    }

    private Boolean validateIndexType(IndexProperty indexProperty) {
        String vectorIndexType = this.jsonSerializable.getString("type");
        if (indexProperty.equals((Object)IndexProperty.QUANTIZATION_SIZE_IN_BYTES)) {
            return vectorIndexType.equals(CosmosVectorIndexType.QUANTIZED_FLAT.toString()) || vectorIndexType.equals(CosmosVectorIndexType.DISK_ANN.toString());
        }
        return vectorIndexType.equals(CosmosVectorIndexType.DISK_ANN.toString());
    }
}

