/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.extensions.implementation.token;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.identity.extensions.implementation.token.AccessTokenResolver;
import com.azure.identity.extensions.implementation.token.AccessTokenResolverOptions;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class AccessTokenResolverImpl
implements AccessTokenResolver {
    private final AccessTokenResolverOptions options;

    AccessTokenResolverImpl() {
        this.options = new AccessTokenResolverOptions();
    }

    public AccessTokenResolverImpl(AccessTokenResolverOptions options) {
        this.options = options;
    }

    @Override
    public Mono<AccessToken> apply(TokenCredential tokenCredential) {
        Objects.requireNonNull(tokenCredential);
        TokenRequestContext request = new TokenRequestContext();
        request.setTenantId(this.options.getTenantId());
        request.setClaims(this.options.getClaims());
        request.addScopes(this.options.getScopes());
        return tokenCredential.getToken(request);
    }
}

