/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AzureCliCredential;
import com.azure.identity.CredentialBuilderBase;
import com.azure.identity.implementation.util.ValidationUtil;

public class AzureCliCredentialBuilder
extends CredentialBuilderBase<AzureCliCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(AzureCliCredentialBuilder.class);
    private String tenantId;

    public AzureCliCredentialBuilder tenantId(String tenantId) {
        ValidationUtil.validateTenantIdCharacterRange(tenantId, LOGGER);
        this.tenantId = tenantId;
        return this;
    }

    public AzureCliCredential build() {
        return new AzureCliCredential(this.tenantId, this.identityClientOptions);
    }
}

