/*
 * Decompiled with CFR 0.152.
 */
package com.azure.json;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class RequiredPropertiesJsonSerializable
implements JsonSerializable<RequiredPropertiesJsonSerializable> {
    private final int anInt;
    private final boolean aBoolean;
    private String aString;
    private Double aNullableDecimal;

    public RequiredPropertiesJsonSerializable(int anInt, boolean aBoolean) {
        this.anInt = anInt;
        this.aBoolean = aBoolean;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeIntField("int", this.anInt).writeBooleanField("boolean", this.aBoolean).writeStringField("string", this.aString).writeNumberField("decimal", (Number)this.aNullableDecimal).writeEndObject();
    }

    public static RequiredPropertiesJsonSerializable fromJson(JsonReader jsonReader) throws IOException {
        return (RequiredPropertiesJsonSerializable)jsonReader.readObject(reader -> {
            int anInt = 0;
            boolean foundAnInt = false;
            boolean aBoolean = false;
            boolean foundABoolean = false;
            String aString = null;
            Double aNullableDecimal = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("int".equals(fieldName)) {
                    anInt = reader.getInt();
                    foundAnInt = true;
                    continue;
                }
                if ("boolean".equals(fieldName)) {
                    aBoolean = reader.getBoolean();
                    foundABoolean = true;
                    continue;
                }
                if ("string".equals(fieldName)) {
                    aString = reader.getString();
                    continue;
                }
                if ("decimal".equals(fieldName)) {
                    aNullableDecimal = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            if (foundAnInt && foundABoolean) {
                RequiredPropertiesJsonSerializable value = new RequiredPropertiesJsonSerializable(anInt, aBoolean);
                value.aString = aString;
                value.aNullableDecimal = aNullableDecimal;
                return value;
            }
            throw new IllegalStateException("Missing required JSON properties. Required properties are 'int' and 'boolean'.");
        });
    }
}

